#include "head.h"

void fifo_init(struct fifo *fifo,int size,struct TASK *task)
{
  fifo->size=size;
  fifo->buffer=(unsigned int *)alloc4((struct manager *)(MANAGER_ADDR),size);
  fifo->free=size;
  fifo->flags=0;
  fifo->write_next=0;
  fifo->read_next=0;
  fifo->task=task;
  return;
}
int fifo_in(struct fifo *fifo,int data)
{
  if(fifo->free==0){
    fifo->flags|=flags_overrun;
    return -1;
  }
  fifo->buffer[fifo->write_next]=data;
  fifo->write_next++;
  if(fifo->write_next==fifo->size){
    fifo->write_next=0;
  }
  fifo->free--;
  if(fifo->task!=0){
    if(fifo->task->flag!=TASK_USING){
      task_run(fifo->task,-1,0);
    }
  }
  return 0;
}
int fifo_out(struct fifo *fifo)
{
  int data;
  if(fifo->free==fifo->size){
    return -1;
  }
  data=fifo->buffer[fifo->read_next];
  fifo->read_next++;
  if(fifo->read_next==fifo->size){
    fifo->read_next=0;
  }
  fifo->free++;
  return data;
}
int fifo_status(struct fifo *fifo)
{
  return fifo->size-fifo->free;
}
void fifo_init_console(struct fifo *fifo,int size,int *buffer,struct TASK *task)
{
  fifo->size=size;
  fifo->free=size;
  fifo->buffer=buffer;
  fifo->flags=0;
  fifo->write_next=0;
  fifo->read_next=0;
  fifo->task=task;
  return;
}

