#include "head.h"
#include <string.h>
#include <stdio.h>
extern struct wcontrol *window_control;
extern struct tcontrol *timer_control;
extern struct TASKCTL *task_control;
void cmd_lsdir(struct CONSOLE *cons);
void cons_runcmd(char *cmdline,struct CONSOLE *cons,int *fat)
{
  if(strcmp(cmdline,"mem")==0){
    cmd_mem(cons);
  }else if(strcmp(cmdline,"cls")==0){
    cmd_cls(cons);
  }else if(strcmp(cmdline,"ls")==0){
    cmd_ls(cons);
  }else if(strcmp(cmdline,"exit")==0){
    cmd_exit(cons,fat);
  }else if(strncmp(cmdline,"write ",6)==0){
    struct FILEHANDLE *fh;
    int i,j;
    char s[30];
    for(j=6;j<cmdline[j]!=0;j++){
      s[j-6]=cmdline[j];
    }
    s[j-6]=0;
    for(i=0;i<8;i++){
      if(cons->fhandle[i].flag==0){
	break;
      }
    }
    if(i>=8){
      fh=0;
    }else{
      fh=file_open(&(cons->fhandle[i]),"NEWFILE.TXT",'w');
      file_write(fh,s,j-6,fh->freq);
      file_close(fh);
    }
  }else if(strncmp(cmdline,"read ",5)==0){
    struct FILEHANDLE fh;
    char *buf;    
    int i,j;
    char s[30];
    for(j=5;j<cmdline[j]!=0;j++){
      s[j-5]=cmdline[j];
    }
    s[j-5]=0;
    if(file_open(&fh,"NEWFILE.TXT",'r')!=0){
      buf=(char *)alloc4((struct manager *)(MANAGER_ADDR),fh.size);
      file_read(&fh,buf,fh.size);
      for(i=0;i<fh.size;i++){
	s[0]=buf[i];
	s[1]=0;
	print_cons(cons,s,siro);
      }
      free4((struct manager *)(MANAGER_ADDR),(unsigned int)buf,fh.size);
      file_close(&fh);
    }
    cons_newline(cons);
  }else if(strncmp(cmdline,"time ",5)==0){
    struct FILEHANDLE *fh;
    int i,j;
    char s[30];
    for(j=5;j<cmdline[j]!=0;j++){
      s[j-5]=cmdline[j];
    }
    s[j-5]=0;
    for(i=0;i<8;i++){
      if(cons->fhandle[i].flag==0){
	break;
      }
    }
    if(i>=8){
      fh=0;
    }else{
      fh=file_open(&(cons->fhandle[i]),s,'r');
      if(fh!=0){

      }
      file_close(fh);
    }
  }else if(strncmp(cmdline,"add ",4)==0){
    struct FILEHANDLE *fh;
    int i,j;
    char s[30];
    for(j=4;j<cmdline[j]!=0;j++){
      s[j-4]=cmdline[j];
    }
    s[j-4]=0;
    for(i=0;i<8;i++){
      if(cons->fhandle[i].flag==0){
	break;
      }
    }
    if(i>=8){
      fh=0;
    }else{
      fh=file_open(&(cons->fhandle[i]),"NEWFILE.TXT",'a');
      file_write(fh,s,j-4,fh->freq);
      file_close(fh);
    }
  }else if(strncmp(cmdline,"mkdir ",6)==0){
    struct FILEINFO *fi;
    int i,j;
    char s[30];
    for(j=6;j<cmdline[j]!=0;j++){
      s[j-6]=cmdline[j];
    }
    s[j-6]=0;
    for(i=0;i<8;i++){
      if(cons->fhandle[i].flag==0){
	break;
      }
    }
    if(i>=8){
      fi=0;
    }else{
      fi=file_create(s,(struct FILEINFO *)(ADR_DISKIMG+0x2600),224,0x10);
      if(fi==0){
	print_cons(cons,"error\n",siro);
      }
    }
  }else if(strcmp(cmdline,"lsdir")==0){
    cmd_lsdir(cons);
  }else if(strcmp(cmdline,"reset")==0){
    reset();
  }else if(cmdline[0]!=0){
    if(cmd_app(cons,fat,cmdline)==0){
      print_cons(cons,"unknown",siro);
    }
    cons_newline(cons);
  }
  cons->cur_x=0;
  cons->cmdline_count=0;
}
void print_cons(struct CONSOLE *cons,char *str,unsigned char color)
{
  /* oO */
  int i;
  for(i=0;str[i]!=0x00;i++){
    print_cons_char(cons,str[i],color);
  }
  return;
}
void print_cons_char(struct CONSOLE *cons,char chr,unsigned char color)
{
  char s[2];
  s[0]=chr;
  s[1]=0;
  if(s[0]==0x09){
    for(;;){
      if((cons->cur_x&0x1f)==0){
	break;
      }
    }
  }else if(s[0]==0x0a){
    cons_newline(cons);
  }else if(s[0]==0x0d){
      
  }else{
    print(cons->window,s,cons->cur_x+cons->shift,cons->cur_y+cons->shift+window_titlesize,color);
    cons->cur_x+=font_xsize;
    if(cons->cur_x>cons->window->xsize-font_xsize-cons->shift*2){
      cons_newline(cons);
    }
  }
}
void cons_newline(struct CONSOLE *cons)
{
  int i,j;
  if(cons->cur_y<(cons->window->ysize-cons->shift-window_titlesize-font_ysize)){
    cons->cur_y+=font_ysize;
  }else{
    for(j=window_titlesize+cons->shift;j<(console_ysize&~16);j++){
      for(i=cons->shift;i<(console_xsize&~8)-cons->shift;i++){
	cons->window->buffer[j*cons->window->xsize+i]=cons->window->buffer[(j+font_ysize)*cons->window->xsize+i];
      }
    }
    refresh_window(cons->window,cons->shift,window_titlesize,(console_xsize&~8)-cons->shift,(console_ysize&~16));
    box(cons->window,cons->shift,(console_xsize&~8)-window_titlesize,(console_xsize&~8)-cons->shift,console_ysize&~16,kuro);
  }
  cons->cur_x=0;
  return;
}
void cmd_mem(struct CONSOLE *cons)
{
  char s[20];
  sprintf(s,"FREE %dKB",memory_total((struct manager *)(MANAGER_ADDR)));
  print_cons(cons,s,siro);
  cons_newline(cons);
}
void cmd_cls(struct CONSOLE *cons)
{
  box(cons->window,0+cons->shift,window_titlesize+cons->shift,cons->window->xsize-cons->shift,cons->window->ysize-cons->shift,kuro);
  cons->cur_y=0;
}
void cmd_ls(struct CONSOLE *cons)
{
  int x,y;
  char s[30];
  struct FILEINFO *finfo=(struct FILEINFO *)(ADR_DISKIMG+0x002600);
  for(x=0;x<MAX_FILES;x++){
    if(finfo[x].name[0]==0x00){
      break;
    }
    if(finfo[x].name[0]!=0xe5){
      if((finfo[x].type&0x18)==0){
	if((finfo[x].type&0x10)==0 && (finfo[x].type&0x08)!=0){
	  print_cons(cons,"DIR ",siro);
	}
	sprintf(s,"filename.ext size:%7d",finfo[x].size);
	for(y=0;y<8;y++){
	  s[y]=finfo[x].name[y];
	}
	s[9]=finfo[x].ext[0];
	s[10]=finfo[x].ext[1];
	s[11]=finfo[x].ext[2];
	print_cons(cons,s,siro);
	cons_newline(cons);
      }
    }
  }
}
void cmd_lsdir(struct CONSOLE *cons)
{
  int x,y;
  char s[30];
  struct FILEINFO *finfo=(struct FILEINFO *)(ADR_DISKIMG+0x002600);
  for(x=0;x<MAX_FILES;x++){
    if(finfo[x].name[0]==0x00){
      break;
    }
    if(finfo[x].name[0]!=0xe5){
      if((finfo[x].type&0x10)==0x10){
	print_cons(cons,"DIR ",siro);
	sprintf(s,"filename");
	for(y=0;y<8;y++){
	  s[y]=finfo[x].name[y];
	}
	print_cons(cons,s,siro);
	cons_newline(cons);
      }
    }
  }
}
int cmd_app(struct CONSOLE *cons,int *fat,char *cmdline)
{
  struct FILEINFO *finfo;
  char name[18],*filepointer,*appmemory;
  int i;
  int segsize,esp,dathrb,datsize;
  struct TASK *task=task_now();
  for(i=0;i<13;i++){
    if(cmdline[i]<=' '){
      break;
    }
    name[i]=cmdline[i];
  }
  name[i]=0;
  finfo=file_search(name,(struct FILEINFO *)(ADR_DISKIMG+0x002600),MAX_FILES);
  if(finfo==0 && name[i-1]!='.'){
    name[i]='.';
    name[i+1]='H';
    name[i+2]='R';
    name[i+3]='B';
    name[i+4]=0;
    finfo=file_search(name,(struct FILEINFO *)(ADR_DISKIMG+0x002600),MAX_FILES);
  }
  if(finfo!=0){
    filepointer=(char *)alloc4((struct manager *)(MANAGER_ADDR),finfo->size);
    file_loadfile(finfo->clustno,finfo->size,filepointer,fat,(char *)(ADR_DISKIMG+0x003e00)); /* mȃ[hoĂȂ񂶂Ȃ */
    if(finfo->size>=36&&strncmp(filepointer+4,"Hari",4)==0&&*filepointer==0x00){
      segsize=*((int *)(filepointer+0x0000));
      esp=*((int *)(filepointer+0x000c));
      datsize=*((int *)(filepointer+0x0010));
      dathrb=*((int *)(filepointer+0x0014));
      appmemory=(char *)alloc4((struct manager *)(MANAGER_ADDR),segsize);
      task->ds_base=(int)appmemory;
      set_segmdesc(task->ldt+0,finfo->size-1,(int)filepointer,ar_code32_er+0x60);
      set_segmdesc(task->ldt+1,segsize-1,(int)appmemory,ar_data32_rw+0x60);
      for(i=0;i<datsize;i++){
	appmemory[esp+i]=filepointer[dathrb+i];
      }
      start_app(0x1b,0*8+4,esp,1*8+4,&(task->tss.esp0));
      for(i=0;i<maxwindow;i++){
      	if((window_control->window[i].use&0x11)==0x11 && window_control->window[i].task==task){
      	  close_window(&window_control->window[i]);
      	}
      }
      for(i=0;i<CONS_FILE_HANDLES;i++){
	if(task->fhandle[i].flag!=0){
	  free4((struct manager *)(MANAGER_ADDR),(int)task->fhandle[i].buf,task->fhandle[i].size);
	  task->fhandle[i].flag=0;
	}
      }
      /* close_windowɃoÔ悤Ȃ̂ŃRg */
      timer_cancelall(&task->fifo);
      free4((struct manager *)(MANAGER_ADDR),(int)appmemory,segsize);
    }else{
      print_cons(cons,".hrb format error\n",siro);
    }
    free4((struct manager *)(MANAGER_ADDR),(int)filepointer,finfo->size);
    return 1;
  }
  return 0;
}
void cmd_exit(struct CONSOLE *cons,int *fat)
{
  struct TASK *task=task_now();
  timer_cancel(task->cons->timer);
  io_cli();
  fifo_in(&(task_control->task_close->fifo),cons->window-window_control->window+256);
  io_sti();
  for(;;){
    task_sleep(task);
  }
}
