#include <stdio.h>
#include <string.h>
#include <errno.h>
#include "head.h"
/*!
 * @brief      KMP@e[u쐬
 * @param[in]  pattern  
 * @return     e[ũ|C^BsNULLԂB
 */
static char *kmp_table_init(const char *pattern)
{
  char *table = NULL;
  int i, j;                      /* p^[̕QƓ_ */
  int ptn_len = strlen(pattern); /* p^[̕ */

  /* KMPe[ü̗mۂ */
  table = (char *)alloc4((struct manager *)(MANAGER_ADDR),(ptn_len + 1));
  if(table == NULL){
    dprint("error",0,0,siro);
    return(NULL);
  }

  /* e[u̒lݒ肷 */
  table[0] = 0;
  for(i = 1, j = 0; i < ptn_len; i++){
    if(pattern[i] != pattern[j]){
      table[i] = 0;
      j = 0;
    }else{
      table[i] = ++j;
    }   
  }
  table[ptn_len] = '\0';

  return(table);
}

/*!
 * @brief      T
 * @param[in]  text     Ώە
 * @param[in]  pattern  
 * @return     ʒũ|C^ԂBsNULLԂB
 */
int kmp_search(const char *text, const char *pattern)
{
  char *table = NULL;
  int i = 0;
  int j = 0;
  /* 炵\쐬 */
  table = kmp_table_init(pattern);
  if(table == NULL) return -1;

  /* r */
  while((text[i] != '\0') && (pattern[j] != '\0')){
    /* ̔r */
    if(text[i] == pattern[j]){
      i++;          /* eLXg̈ʒuPi߂ */
      j++;          /* p^[̈ʒuPi߂ */
    }else if(j == 0){
      i++;          /* eLXg̈ʒuPi߂ */
    }else{
      j = table[j -1]; /* 炵\QƂĐi߂ */
    }
  }

  /* 炵\ */
  if(table != NULL){
    free4((struct manager *)(MANAGER_ADDR),(unsigned int)table,(strlen(pattern)+1));
  }
  if(pattern[j] != '\0') return -1;
  return (i-j);
}
