/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpolicy;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;

import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.ui.editors.layout.commands.SetPropertyCommand;
import jp.sf.maskat.ui.editors.layout.editpolicies.DataBindingEditPolicy;
import jp.sf.maskat.ui.editors.layout.requests.DataBindingRequest;

public class RadioDataBindingEditPolicy extends DataBindingEditPolicy {
	protected Command createDataBindingCommand(DataBindingRequest request) {
		EditPart editPart = getTargetEditPart(request);
		if (editPart != null) {
			String value = (String) ((DynaComponent) editPart.getModel()).get("group"); //$NON-NLS-1$	
			return new SetPropertyCommand(request.getBean(), request.getPropertyName(),
					value);
		}
		return null;
	}
}
