/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpart;

import java.beans.PropertyChangeEvent;

import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.HorizontalResizable;
import jp.sf.maskat.ui.editors.layout.editparts.LabelDirectEditable;
import jp.sf.maskat.widget.rialto.figure.ButtonFigure;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;



public class ButtonEditPart extends ComponentEditPart
	implements LabelDirectEditable, HorizontalResizable {

	protected IFigure createFigure() {
		return new ButtonFigure(getLabel());
	}

	protected void refreshVisuals() {
		DynaComponent comp = (DynaComponent) getModel();
		Dimension d = getFigure().getPreferredSize();
		
		int height = d.height;
		Boolean vb = (Boolean) comp.get("adaptToText");
		boolean adaptToText = vb != null ? vb.booleanValue() : false;

		int width =  adaptToText ? d.width : comp.getWidth();
		
		Integer vi = (Integer) comp.get("widthMin");
		int widthMin = vi != null ? vi.intValue() : 0;
		width = (widthMin > width) ? widthMin : width;

		Rectangle constraint = new Rectangle(comp.getLeft(), comp.getTop(),
				width, height);
		if (getParent() != null) {
			((GraphicalEditPart) getParent()).setLayoutConstraint(this,
					getFigure(), constraint);
		}
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("title".equals(evt.getPropertyName())) {
			((ButtonFigure) getFigure()).setText((String) evt.getNewValue());
		}
		super.propertyChange(evt);
	}
	
	public String getLabel() {
		return (String) ((DynaComponent) getModel()).get("title");
	}

	public void setLabel(String text) {
		((DynaComponent) getModel()).set("title", text);
	}

}
