/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper;

import java.util.ArrayList;

import jp.sf.maskat.core.event.Event;
import jp.sf.maskat.core.event.Result;
import jp.sf.maskat.core.event.Target;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.LocalDataBinding;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.ResultTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.command.AddTreeNodeCommand;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;


public class LocalDataBindingTreeNode extends AbstractTreeNode {
	private static final String LOCALDATA_BINDING =
		Messages.getString("localDataBindingTreeNode.localDataBinding"); //$NON-NLS-1$		

	private static final String ADD_LOCALDATABINDING =
		Messages.getString("localDataBindingTreeNode.addLocalDataBinding"); //$NON-NLS-1$
	
	public LocalDataBindingTreeNode(Event event) {
		super(event);
	}

	public Object[] getLocalDatabinding() {
		Event event = (Event) maskatElement;
		ArrayList arrayList = new ArrayList();

		Result result = event.getResult();

		if (result != null && "remote".equals(event.getType())) {
			Target[] targets = result.getTargets();
			for (int i = 0; i < targets.length; i++) {
				if ("local".equals(targets[i].getType())) {
					arrayList.add(new LocalDataBinding(targets[i]));
				}
			}
		} else if (result != null && "local".equals(event.getType())) {
			Target[] targets = result.getTargets();
			for (int i = 0; i < targets.length; i++) {
				arrayList.add(new LocalDataBinding(targets[i]));
			}			
		}
		return arrayList.size() > 0 ? arrayList.toArray() : null;
	}

	protected void loadChildren() {
		Event event = (Event) maskatElement;
		Result result = event.getResult();
		if (result == null) {
			return;
		}
		if ("remote".equals(event.getType())) {
			Target[] targets = result.getTargets();
			for (int i = 0; i < targets.length; i++) {
				if ("local".equals(targets[i].getType())) {
					addChild(new LocalDataBinding(targets[i]));
				}
			}
		} else if ("local".equals(event.getType())) {
			Target[] targets = result.getTargets();
			for (int i = 0; i < targets.length; i++) {
				addChild(new LocalDataBinding(targets[i]));
			}			
		}
	}
	
	/**destroy the Target bean and Result bean when the child was removed*/
	public void removeChild(ITreeNode child) {
		super.removeChild(child);
		//destroy the Target bean and Result bean
		Target target = (Target)child.getModel();
		Result result = (Result)target.getParent();
		result.removeChild(target);
		if (result.getTypedChildren(Target.class) == null
			&& "local".equals(((Event)maskatElement).getType())) {
			maskatElement.removeChild(result);
		} else if(result.getTypedChildren(Target.class) == null
				&& EventPropertiesMasterDetailsBlock.getTreeNode(result, ResultTreeNode.class) == null) {
			maskatElement.removeChild(result);			
		}
	}
	
	/**add the model relation when add child*/
	public void addChild(ITreeNode child) {
		super.addChild(child);
		Result result = ((Event)maskatElement).getResult();
		if (result == null) {
			result = new Result();
			result.addChild(child.getModel());
			maskatElement.addChild(result);
		}else{
			result.addChild(child.getModel());
		}
		result.setEnable(true);
	}

	public String getDisplayText() {
		return LOCALDATA_BINDING;
	}
	
	public boolean isDeletable() {
		return false;
	}
	
	public IMenuManager fillContextMenu(final TreeViewer treeViewer, IMenuManager manager) {
		final ITreeNode node = this;
		manager.add(new Action(ADD_LOCALDATABINDING){
			public void run() {
				
				Target target = new Target();
				target.setType("local");
//				target.setIn("");
//				target.setOut("");
//				target.setWorkType("");
							
				ITreeNode childNode = new LocalDataBinding(target);
				EventPropertiesMasterDetailsBlock.executeCommand(new AddTreeNodeCommand(treeViewer,node,childNode));

				if ("remote".equalsIgnoreCase(((Event)maskatElement).getType())) {
					//we need to add Result to MessageToBeReceived
					ITreeNode messageReceive = findMessageReceiveTreeNode();
					if (messageReceive != null) {
						//add the result node if it was not added
						if (messageReceive.getChildren().length == 0) {
							EventPropertiesMasterDetailsBlock.executeCommand(new AddTreeNodeCommand(
									treeViewer,messageReceive,new ResultTreeNode((Result)target.getParent())));
							treeViewer.setSelection(new StructuredSelection(childNode), true);
							treeViewer.update(childNode, null);
						}
					}
				}
			}
		});
		return super.fillContextMenu(treeViewer, manager);
	}
	
	private ITreeNode findMessageReceiveTreeNode() {
		ITreeNode root = getParent().getParent();
		Object[] rootChildren = root.getChildren();
		for (int i=0; i<rootChildren.length; i++) {
			if (rootChildren[i] instanceof MessageToBeReceivedTreeNode) {
				return (ITreeNode)rootChildren[i];
			}
		}
		return null;
	}
}
