/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.tools;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.gef.tools.TargetingTool;

public class PopupBarTool extends TargetingTool
	implements DragTracker {
	
	private CreationFactory factory;
	
	private CreateRequest currentRequest; 
	
	private EditPart targetEditPart;
	
	public PopupBarTool(EditPart editPart, CreationFactory factory) {
		this.factory = factory;
		this.targetEditPart = editPart;
		lockTargetEditPart(editPart);
	}

	private static final int FLAG_LOCK_TARGET = AbstractTool.MAX_FLAG << 1;
	protected void lockTargetEditPart(EditPart editpart) {
		if (editpart == null)  {
			unlockTargetEditPart();
			return;
		}
		setFlag(FLAG_LOCK_TARGET, true);
		setTargetEditPart(editpart);
	}	

	protected EditPart getTargetEditPart() {
		return this.targetEditPart;
	}
	
	protected void unlockTargetEditPart() {
		// NULL implementation
	}
	
	protected boolean handleButtonDown(int button) {
		setCurrentCommand(getCommand());
		return super.handleButtonDown(button);
	}

	protected boolean handleButtonUp(int button) {
		executeCurrentCommand();
		if (currentRequest != null) {
			final Object model = currentRequest.getNewObject();
			EditPartViewer viewer = getCurrentViewer();
			if (model != null && viewer != null) {
				Object editPart = viewer.getEditPartRegistry().get(model);
				if (editPart instanceof EditPart) {
					viewer.select((EditPart) editPart);
				}
			}
		}
		currentRequest = null;
		return true;
	}

	protected String getCommandName() {
		return REQ_CREATE;
	}
	
	protected Request createTargetRequest() {
		CreateRequest request = new CreateRequest();
		request.setFactory(factory);
		request.setLocation(getMouseLocation());
		request.setSize(new Dimension(-1, -1));
		currentRequest = request;
		return request;
	}
	
	private Point getMouseLocation() {
		//return getCurrentInput().getMouseLocation();
		IFigure figure = ((GraphicalEditPart) targetEditPart).getFigure();
		Rectangle rect = figure.getBounds().getCopy();
		Insets inset = figure.getInsets();
		if (inset != null) {
			rect.x += inset.left;
			rect.y += inset.top;
		}
		return new Point(rect.x, rect.y);
	}
	
	public boolean isCommandEnabled() {
		Command cmd = this.getCommand();
		if (cmd == null) {
			return false;
		}
		return cmd.canExecute();
	}

	/**
	 * @see org.eclipse.gef.DragTracker#commitDrag()
	 */
	public void commitDrag() {
		// NULL implementation
	}
}
