/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.tools;

import org.eclipse.gef.SharedImages;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.palette.ToolEntry;

public class AdvancedSelectionToolEntry extends ToolEntry {
	/**
	 * Creates a new SelectionToolEntry.
	 */
	public AdvancedSelectionToolEntry() {
		this(null);
	}

	/**
	 * Constructor for SelectionToolEntry.
	 * @param label the label
	 */
	public AdvancedSelectionToolEntry(String label) {
		this(label, null);
	}

	/**
	 * Constructor for SelectionToolEntry.
	 * @param label the label
	 * @param shortDesc the description
	 */
	public AdvancedSelectionToolEntry(String label, String shortDesc) {
		super(label, shortDesc, SharedImages.DESC_SELECTION_TOOL_16,
				SharedImages.DESC_SELECTION_TOOL_24, AdvancedSelectionTool.class);
		if (label == null || label.length() == 0)
			setLabel(GEFMessages.SelectionTool_Label);
		setUserModificationPermission(PERMISSION_NO_MODIFICATION);
	}
}
