/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.event;

/**
 * リモートイベントで送信される応答メッセージのXML要素からバインド
 * するレイアウト部品または変数の対応付けを定義するクラスです。
 */
public class Target extends AbstractEventElement {

	/**
	 * データ取得元の種別（デフォルト値）
	 */
	public static final String TYPE_DEFAULT = "remote";

	/**
	 * 出力オブジェクト名
	 * データ格納先となるGUIオブジェクト名もしくは変数名
	 */
	private String out;

	/**
	 * HTTP応答メッセージに生成するXML要素名
	 * ここで指定した名前を持つXML要素名がルート要素の下に生成される
	 */
	private String in;

	/**
	 * 受信XMLの子ノード名もしくは参照オブジェクトのプロパティ名
	 */
	private String inkey;

	/**
	 * データ取得元の種別
	 */	
	private String type = TYPE_DEFAULT;

	/**
	 * データ設定メソッド名
	 */
	private String teleType;

	/**
	 * ローカルデータバイディングのハンドラ関数
	 */
	private String workType;

	/**
	 * デフォルトコンストラクタです
	 */
	public Target() {
		super();
	}
	
	/**
	 * 応答メッセージのXML要素名を取得します
	 * 
	 * @return 応答メッセージのXML要素名
	 */
	public String getIn() {
		return in;
	}

	/**
	 * 応答メッセージのXML要素名を設定します
	 * 
	 * @param in 応答メッセージのXML要素名
	 */
	public void setIn(String in) {
		this.in = in;
	}

	/**
	 * 受信XMLの子ノード名もしくは参照オブジェクトの
	 * プロパティ名を取得します
	 * 
	 * @return 子ノード名もしくはプロパティ名
	 */
	public String getInkey() {
		return inkey;
	}

	/**
	 * 受信XMLの子ノード名もしくは参照オブジェクトの
	 * プロパティ名を設定します
	 * 
	 * @param inkey 子ノード名もしくはプロパティ名
	 */
	public void setInkey(String inkey) {
		this.inkey = inkey;
	}

	/**
	 * 出力オブジェクト名を取得します
	 *  
	 * @return データ格納先となるGUIオブジェクト名もしくは変数名
	 */
	public String getOut() {
		return out;
	}

	/**
	 * 出力オブジェクト名を設定します
	 * 
	 * @param out データ格納先となるGUIオブジェクト名もしくは変数名
	 */
	public void setOut(String out) {
		this.out = out;
	}

	/**
	 * データ取得元の種別を取得します
	 * 
	 * @return データ取得元の種別
	 */
	public String getType() {
		return type;
	}

	/**
	 * データ取得元の種別を設定します
	 * 
	 * @param type データ取得元の種別
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * データ設定メソッド名を取得します
	 * 
	 * @return データ設定メソッド名
	 */
	public String getTeleType() {
		return teleType;
	}

	/**
	 * データ設定メソッド名を設定します
	 * 
	 * @param teleType データ設定メソッド名
	 */
	public void setTeleType(String teleType) {
		this.teleType = teleType;
	}

	/**
	 * ローカルデータバイディングのハンドラ関数名を取得します
	 * 
	 * @return ローカルデータバイディングのハンドラ関数名
	 */
	public String getWorkType() {
		return workType;
	}

	/**
	 * ローカルデータバイディングのハンドラ関数名を設定します
	 * 
	 * @param workType ローカルデータバイディングのハンドラ関数名
	 */
	public void setWorkType(String workType) {
		this.workType = workType;
	}

	/**
	 * バインド要素を配列で取得します
	 * 
	 * @return バインド要素の配列
	 */
	public Bind[] getBinds() {
		return (Bind[]) getTypedChildren(Bind.class)
				.toArray(new Bind[0]);
	}
}
