/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.betwixt;

import java.io.IOException;

import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MaskatEntityResolver implements EntityResolver {

	public static final String EVENT_DEF_DTD = "eventDef.dtd";
	public static final String LAYOUT_DEF_DTD = "layoutDef.dtd";

	public InputSource resolveEntity(String publicID, String systemID) throws SAXException,
			IOException {
		
		if(systemID.endsWith(EVENT_DEF_DTD)) {
			return new InputSource(getClass().getResourceAsStream(EVENT_DEF_DTD));
		}
		else if(systemID.endsWith(LAYOUT_DEF_DTD)) {
			return new InputSource(getClass().getResourceAsStream(LAYOUT_DEF_DTD));
		}
		// return null to makes process continue normally
		return null;
	}

}
