/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpart;

import java.beans.PropertyChangeEvent;

import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.LabelDirectEditable;
import jp.sf.maskat.ui.editors.layout.editpolicies.DataBindingEditPolicy;
import jp.sf.maskat.widget.rialto.editpolicy.RadioDataBindingEditPolicy;
import jp.sf.maskat.widget.rialto.figure.RadioFigure;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;

public class RadioEditPart extends ComponentEditPart
	implements LabelDirectEditable {
	
	public void setModel(Object model) {
		super.setModel(model);
	}

	protected IFigure createFigure() {
		IFigure figure = new RadioFigure(getLabel());
		return figure;
	}

	protected void createEditPolicies() {
		super.createEditPolicies();
		//installEditPolicy(EditPolicy.COMPONENT_ROLE, new RadioComponentEditPolicy());
		installEditPolicy(DataBindingEditPolicy.ROLE, new RadioDataBindingEditPolicy());
	}
	
	protected void refreshVisuals() {
		Component comp = (Component) getModel();
		Dimension d = getFigure().getPreferredSize();
		
		Rectangle constraint = new Rectangle(comp.getLeft(), comp.getTop(), d.width,
				d.height);
		GraphicalEditPart editPart = (GraphicalEditPart) getParent();
		if (editPart != null) {
			editPart.setLayoutConstraint(this, getFigure(), constraint);
		}
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if ("text".equals(evt.getPropertyName())) {
			((RadioFigure) getFigure()).setText((String) evt.getNewValue());
		}
		super.propertyChange(evt);
	}

	public String getLabel() {
		return (String) ((DynaComponent) getModel()).get("text");
	}

	public void setLabel(String text) {
		((DynaComponent) getModel()).set("text", text);
	}
}
