/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class RialtoPlugin extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "jp.sf.maskat.widget.rialto";

	// The shared instance
	private static RialtoPlugin plugin;

	public static final String IMG_COMPONENTICON = "IMG_COMPONENTICON"; //$NON-NLS-1$
	public static final String IMG_CHECKBOXUNCHECKED = "IMG_CHECKBOXUNCHECKED"; //$NON-NLS-1$
	public static final String IMG_RADIOUNCHECKED = "IMG_RADIOUNCHECKED"; //$NON-NLS-1$
	public static final String IMG_COMBOBOXDROPDOWN = "IMG_COMBOBOXDROPDOWN"; //$NON-NLS-1$
	public static final String IMG_CODELIBBUTTON = "IMG_CODELIBBUTTON"; //$NON-NLS-1$
	
	/**
	 * The constructor
	 */
	public RialtoPlugin() {
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static RialtoPlugin getDefault() {
		return plugin;
	}
	protected void initializeImageRegistry(ImageRegistry reg) {

		reg.put(IMG_COMPONENTICON, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/componenticon.gif")); //$NON-NLS-1$
		reg.put(IMG_CHECKBOXUNCHECKED, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/checkboxenabledoff.gif")); //$NON-NLS-1$
		reg.put(IMG_RADIOUNCHECKED, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/radioboxenableoff.gif")); //$NON-NLS-1$
		reg.put(IMG_COMBOBOXDROPDOWN, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/comboboxdropdown.gif")); //$NON-NLS-1$
		reg.put(IMG_CODELIBBUTTON, imageDescriptorFromPlugin(PLUGIN_ID,
				"icons/full/etool16/codelibbutton.gif")); //$NON-NLS-1$		
	}

	public static ImageDescriptor getImageDescriptor(IConfigurationElement element,
			String attributeName) {
		String path = element.getAttribute(attributeName);
		if (path == null) {
			return null;
		}
		String pluginId = element.getDeclaringExtension().getNamespaceIdentifier();
		return AbstractUIPlugin.imageDescriptorFromPlugin(pluginId, path);
	}

	public static Image getImage(String key) {
		return getDefault().getImageRegistry().get(key);
	}

	public static ImageDescriptor getImageDescriptor(String key) {
		return getDefault().getImageRegistry().getDescriptor(key);
	}

}
