/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.wizards.export;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.event.Component;
import jp.sf.maskat.core.event.Event;
import jp.sf.maskat.core.event.EventDef;
import jp.sf.maskat.core.event.EventElement;
import jp.sf.maskat.core.event.Param;


public class ExportMessage {
	private String componentName;
	
	private String eventName;
	
	private String type;

	private EventElement element;
	
	
	public static final String REQUEST = "request"; //$NON-NLS-1$
	
	public static final String REQPONSE = "response"; //$NON-NLS-1$
	
	
	public ExportMessage(Event event, EventElement element) {
		
		if (element instanceof Param) {
			type= REQUEST;
		} else {
			type = REQPONSE;
		}
		MaskatElement ce = event.getParent();
		if (event instanceof Event) {
			if (ce instanceof EventDef) {
				setComponentName("EventDef"); //$NON-NLS-1$
			} else {
				setComponentName(((Component) ce).getId());
			}
			setEventName(event.getId());
			setElement(element);
		}
	}
	
	public String getComponentName() {
		return componentName;
	}

	public void setComponentName(String name) {
		componentName = name;
	}
	
	public String getEventName() {
		return eventName;
	}

	public void setEventName(String name) {
		eventName = name;
	}
	
	public String getFileName() {
		StringBuffer sb = new StringBuffer();
		sb.append(eventName);
		sb.append("_"); //$NON-NLS-1$
		sb.append(type);
		sb.append(".xsd"); //$NON-NLS-1$
		return sb.toString();
	}
	
	public String getType() {
		return type;
	}
	
	public EventElement getElement() {
		return element;
	}

	public void setElement(EventElement event) {
		element = event;
	}
}
