/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.beanwrapper;

import jp.sf.maskat.core.event.Bind;
import jp.sf.maskat.core.event.Target;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.views.properties.tabbed.action.DeleteTargetNodeAction;
import jp.sf.maskat.ui.views.properties.tabbed.command.AddTreeNodeCommand;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.AbstractTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;

public class TargetNode extends AbstractTreeNode {

	private static final String TARGETIN_SINGLE_LABEL =
		Messages.getString("targetNode.singleValueLabel"); //$NON-NLS-1$

	private static final String TARGETIN_MULTI_LABEL =
		Messages.getString("targetNode.multiValueLabel"); //$NON-NLS-1$

	private static final String ADD_TARGETCHILDNODE =
		Messages.getString("targetNode.addTargetChildNode"); //$NON-NLS-1$

	
	public TargetNode(Target target) 
	{
		super(target);
	}

	protected void loadChildren() {
		Target target = (Target)maskatElement;
		if(target.getInkey() != null) {
			addChild(new TargetChildNode(target));
		}
	}
	
	/**set the Inkey of target to null when remove child*/
	public void removeChild(ITreeNode child) {
		super.removeChild(child);
		((Target) maskatElement).setInkey(null);
		((Target) maskatElement).removeAllByType(Bind.class);
	}
	
	/**add the model relation when add child*/
	public void addChild(ITreeNode child) {
		super.addChild(child);
		if (((Target) maskatElement).getInkey() == null) {
			((Target) maskatElement).setInkey("");
		}
	}

	public String getDisplayText() {
		String label = ((Target) maskatElement).getInkey() == null ? TARGETIN_SINGLE_LABEL: TARGETIN_MULTI_LABEL;
		if(((Target) maskatElement).getIn() == null
			|| ((Target) maskatElement).getIn().length() == 0) {
			return label;
		}
		return ((Target) maskatElement).getIn() + " " + label;
	}
	
	public IMenuManager fillContextMenu(final TreeViewer treeViewer, IMenuManager manager) {
		final ITreeNode node = this;
		final Target target = (Target)maskatElement;
		if (!node.containsChild(TargetChildNode.class)) {
			manager.add(new Action(ADD_TARGETCHILDNODE){
				public void run() {
					ITreeNode childNode = new TargetChildNode(target);
					EventPropertiesMasterDetailsBlock.executeCommand(new AddTreeNodeCommand(treeViewer,node,childNode));					
				}
			});
		}
		manager.add(new Separator()); 
	 	manager.add(new DeleteTargetNodeAction(treeViewer, this)); 
	 	return manager;
	}
	
	public boolean isCopiable() {
		return true;
	}
	
	public boolean canPasteTo(ITreeNode parent) {
		return (parent != null && parent instanceof ResultTreeNode) ? true : false;
	}
}
