/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;

public class DynaComponentFigure extends Label {

	private int style;

	public DynaComponentFigure(String name) {
		this(name, PositionConstants.CENTER);
	}
	public DynaComponentFigure(String name, int style) {
		setText(name);
		this.style = style;
		setForegroundColor(ColorConstants.black);
		setFont(TextFigure.DEFAULT_FONT);
		setBorder(new CompoundBorder(new LineBorder(), new MarginBorder(1)));
		setBackgroundColor(ColorConstants.gray);
		setOpaque(false);
		setLayoutManager(new XYLayout());
	}

	protected Point getTextLocation() {
		Point p = null;
		switch (style) {
		case PositionConstants.LEFT:
			p = new Point(5, 0);
			break;
			
		case PositionConstants.CENTER:
		default:
			p = super.getTextLocation();
			break;
		}
		return p;
	}
}
