/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.editparts;

import java.beans.PropertyChangeEvent;
import java.util.List;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.ui.editors.layout.editpolicies.ComponentXYLayoutEditPolicy;
import jp.sf.maskat.ui.editors.layout.editpolicies.LabelDirectEditPolicy;
import jp.sf.maskat.ui.editors.layout.figures.LayoutFigure;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;


public class LayoutEditPart extends ComponentEditPart {
	
	protected IFigure createFigure() {
		return new LayoutFigure();
	}

	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new ComponentXYLayoutEditPolicy());
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE, new LabelDirectEditPolicy());
		installEditPolicy("Snap Feedback", new SnapFeedbackPolicy());
	}

	protected List getModelChildren() {
		List result = null;
		if (getModel() instanceof MaskatElement) {
			result = ((MaskatElement) getModel()).getChildren();
		}
		if (result != null) {
			return result;
		}
		return super.getModelChildren();
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if ("addChild".equals(evt.getPropertyName())
				|| "removeChild".equals(evt.getPropertyName())) {
			refresh();
		}
		super.propertyChange(evt);
	}

	public boolean canCopy() {
		return false;
	}

	public boolean canDelete() {
		return false;
	}
}
