/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.editparts;

import java.util.HashMap;
import java.util.Map;

import jp.sf.maskat.core.layout.ComponentRegistry;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.editors.layout.figures.DynaComponentFigureFactory;
import jp.sf.maskat.ui.editors.layout.figures.IFigureFactory;

import org.apache.commons.beanutils.DynaClass;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.jface.resource.ImageDescriptor;


public class DynaComponentEditPartFactory implements EditPartFactory {

	private static Map registry = new HashMap();

	static {
		IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(
				MaskatUIPlugin.PLUGIN_ID, "editPartFactories"); //$NON-NLS-1$
		IExtension[] extensions = point.getExtensions();

		for (int i = 0; i < extensions.length; i++) {
			IConfigurationElement[] elements = extensions[i].getConfigurationElements();
			for (int j = 0; j < elements.length; j++) {
				IConfigurationElement element = elements[j];
				if ("editPart".equals(element.getName())) { //$NON-NLS-1$
					Object type = ComponentRegistry.getComponentType(
							element.getAttribute("namespaceURI"), //$NON-NLS-1$
							element.getAttribute("name")); //$NON-NLS-1$
					registry.put(type, element);
				}
			}
		}
	}

	public static ImageDescriptor getImageDescriptor(Object model) {
		if (model instanceof DynaComponent) {
			DynaClass type = ((DynaComponent) model).getDynaClass();
			if (registry.containsKey(type)) {
				return MaskatUIPlugin.getImageDescriptor(
						(IConfigurationElement) registry.get(type),
						"icon"); //$NON-NLS-1$
			}
		}
		return null;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.EditPartFactory#createEditPart(org.eclipse.gef.EditPart,
	 *      java.lang.Object)
	 */
	public EditPart createEditPart(EditPart context, Object model) {
		EditPart editPart = null;

		if (model instanceof DynaComponent) {
			DynaClass type = ((DynaComponent) model).getDynaClass();
			if (registry.containsKey(type)) {
				editPart = createEditPartFromRegistry((IConfigurationElement) registry
						.get(type), model);
			} else {
				editPart = new DynaComponentEditPart();
			}
		} else {
			editPart = new UnknownElementEditPart();
		}

		editPart.setModel(model);
		return editPart;
	}

	private EditPart createEditPartFromRegistry(IConfigurationElement element,
			Object model) {
		if (element.getAttribute("class") != null) {
			try {
				return  (EditPart) element.createExecutableExtension("class");
			} catch (CoreException e) {
				MaskatUIPlugin.log(e.getStatus());
			}
		}
		
		DynaComponentEditPart editPart = new DynaComponentEditPart();
		IConfigurationElement[] children = element.getChildren("figure");
		if (children.length > 0) {
			IConfigurationElement child = children[0];
			if (child.getAttribute("factory") != null) {
				try {
					editPart.setFigureFactory((IFigureFactory) element
							.createExecutableExtension("factory"));
				} catch (CoreException e) {
					MaskatUIPlugin.log(e.getStatus());
				}
			} else if (child.getAttribute("type") != null) {
				editPart.setFigureFactory(new DynaComponentFigureFactory(child
						.getAttribute("type")));
			}
			
			String width = child.getAttribute("width");
			if (width != null && !"resizable".equals(width)) {
				editPart.setWidth(Integer.parseInt(width));
			}

			String height = child.getAttribute("height");
			if (height != null && !"resizable".equals(height)) {
				editPart.setHeight(Integer.parseInt(height));
			}
		}
		return editPart;
	}

}
