/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.editors.layout.editparts.LayoutElementEditPart;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

/**
 * カットアクションクラスです
 * 
 * レイアウトエディタのメニュー、コンテキストメニューから呼び出され
 * 現在選択しているLayoutElementクラスの切り取りを行います。
 *
 */
public class CutComponentAction extends CopyComponentAction {

	/**
	 * 削除リクエスト
	 */
	private static Request request = new GroupRequest(
			RequestConstants.REQ_DELETE);

	/**
	 * コンストラクタです
	 * 
	 * @param part アクションを行うWorkbenchPart
	 */
	public CutComponentAction(IWorkbenchPart part) {
		super(part);
		setId(ActionFactory.CUT.getId());
		setText(Messages.getString("layout.cmd.cut.msg.title")); //$NON-NLS-1$
		setToolTipText(Messages.getString("layout.cmd.cut.msg.title")); //$NON-NLS-1$
		ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
		setImageDescriptor(sharedImages.getImageDescriptor(ISharedImages.IMG_TOOL_CUT));
		setDisabledImageDescriptor(sharedImages.getImageDescriptor(ISharedImages.IMG_TOOL_CUT_DISABLED));
	}

	/**
     * カットが行えるか判定します。
     * 
     * @return カットが行える場合、trueを返却します
	 */
	protected boolean calculateEnabled() {
		if (!super.calculateEnabled()) {
			return false;
		}

		List objects = getSelectedObjects();
		if (objects.isEmpty()) {
			return false;
		}
		for (int i = 0; i < objects.size(); i++) {
			EditPart part = (EditPart) objects.get(i);
			if (!(part instanceof LayoutElementEditPart)) {
				return false;
			}
			if (!((LayoutElementEditPart) part).canDelete()) {
				return false;
			}
		}
		Command cmd = createDeleteCommand();
		return (cmd != null) && cmd.canExecute();
	}

	/**
	 * 選択されているコンポーネントをリストで取得します
	 * 
	 * @return 選択されているコンポーネントの配列
	 */
	protected List getOperationSet() {
		List editparts = new ArrayList(getSelectedObjects());
		if (editparts.isEmpty()
				|| !(editparts.get(0) instanceof GraphicalEditPart)) {
			return Collections.EMPTY_LIST;
		}
		return editparts;
	}

	/**
	 * 削除コマンドを生成します
	 * 
	 * @return 削除コマンド
	 */
	private Command createDeleteCommand() {
		List operationSet = getOperationSet();

		CompoundCommand command = new CompoundCommand();
		command.setDebugLabel(getText());
		for (int i = 0; i < operationSet.size(); i++) {
			EditPart editpart = (EditPart) operationSet.get(i);
			command.add(editpart.getCommand(request));
		}
		return command;
	}

	/**
	 * 削除コマンドを実行して選択されているコンポーネントを削除します
	 */
	public void run() {
		super.run();
		execute(createDeleteCommand());
	}
}
