/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

/**
 * マスカットプロパティ画面に表示されるレイアウトエディタ部分の
 * 描画および制御を行うクラスです。
 */
public class LayoutEditorDialogArea extends Composite {

	/**
	 * 「グリッドを表示する」チェックボタン
	 */
	private Button gridView;

	/**
	 * 「オブジェクト吸着なし」のラジオボタン
	 */
	private Button noSnap;

	/**
	 * 「グリッドに合わせる」のラジオボタン
	 */
	private Button snapToGrid;

	/**
	 * 「オブジェクトに合わせる」のラジオボタン
	 */
	private Button snapToObj;

	/**
	 * 「グリッド間隔」のスピナー
	 */
	private Spinner gridSize;

	
	/**
	 * コンストラクタです
	 * 
	 * @param parent 親コンポジット
	 * @param style 表示スタイル
	 */
	public LayoutEditorDialogArea(Composite parent, int style) {
		super(parent, style);
		createControl();
	}

	/**
	 * レイアウトエディタ部分の画面作成
	 */
	private void createControl() {
		setLayout(new GridLayout());
		setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		Group layoutGroup = new Group(this, SWT.NONE);
		GridLayout layout = new GridLayout(3, false);
		layout.marginLeft = 5;
		layoutGroup.setLayout(layout);
		layoutGroup.setLayoutData(new GridData(GridData.FILL_BOTH));
		layoutGroup.setText(Messages.getString(
				"property.layout.group.title")); //$NON-NLS-1$

		gridView = new Button(layoutGroup, SWT.CHECK | SWT.RIGHT);
		GridData gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridView.setLayoutData(gridData);
		gridView.setText(Messages.getString(
				"property.layout.grid")); //$NON-NLS-1$

		Label betweenLabel = new Label(layoutGroup, SWT.RIGHT);
		GridData betweenData = new GridData(GridData.FILL_HORIZONTAL);
		betweenData.horizontalSpan = 1;
		betweenLabel.setLayoutData(betweenData);
		betweenLabel.setText(Messages.getString(
				"property.layout.gridspan")); //$NON-NLS-1$		

		gridSize = new Spinner(layoutGroup, SWT.BORDER);
		gridSize.setMinimum(1);
		gridSize.setMaximum(100);
		gridSize.setSelection(15);

		Group snapGroup = new Group(layoutGroup, SWT.NONE);
		GridLayout snapLayout = new GridLayout(1, false);
		snapLayout.marginLeft = 5;
		snapGroup.setLayout(snapLayout);
		snapGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		snapGroup.setText(Messages.getString(
				"property.layout.label.snap")); //$NON-NLS-1$

		noSnap = new Button(snapGroup, SWT.RADIO);
		noSnap.setText(Messages.getString(
				"property.layout.label.nosnap")); //$NON-NLS-1$
		snapToGrid = new Button(snapGroup, SWT.RADIO);
		snapToGrid.setText(Messages.getString(
				"property.layout.label.snapTogrid")); //$NON-NLS-1$
		snapToObj = new Button(snapGroup, SWT.RADIO);
		snapToObj.setText(Messages.getString(
				"property.layout.label.snapToobj")); //$NON-NLS-1$        
	}

	/**
	 * 「グリッドを表示する」の状態を設定します
	 * 
	 * @param v 「グリッドを表示する」を選択する場合には true
	 */
	public void setGridSelection(boolean v) {
		gridView.setSelection(v);
	}

	/**
	 * 「グリッドを表示する」の状態を取得します
	 * 
	 * @return 「グリッドを表示する」が選択されている場合には true
	 */
	public boolean getGridSelection() {
		return gridView.getSelection();
	}

	/**
	 * 「グリッドに合わせる」の状態を設定します
	 * 
	 * @param v 「グリッドに合わせる」を選択する場合には true
	 */
	public void setSnapToGridSelection(boolean v) {
		snapToGrid.setSelection(v);
		if (v) {
			noSnap.setSelection(false);
			snapToObj.setSelection(false);
		} else if (!snapToObj.getSelection()) {
			noSnap.setSelection(true);
		}
	}

	/**
	 * 「グリッドに合わせる」の状態を取得します
	 * 
	 * @return 「グリッドに合わせる」が選択されている場合には true
	 */
	public boolean getSnapToGridSelection() {
		return snapToGrid.getSelection();
	}

	/**
	 * 「オブジェクトに合わせる」の状態を設定します
	 * 
	 * @param v 「オブジェクトに合わせる」を選択する場合には true
	 */
	public void setSnapToObjectSelection(boolean v) {
		snapToObj.setSelection(v);
		if (v) {
			noSnap.setSelection(false);
			snapToGrid.setSelection(false);
		} else if (!snapToGrid.getSelection()) {
			noSnap.setSelection(true);
		}
	}

	/**
	 * 「オブジェクトに合わせる」の状態を取得します
	 * 
	 * @return 「オブジェクトに合わせる」が選択されている場合には true
	 */
	public boolean getSnapToObjectSelection() {
		return snapToObj.getSelection();
	}

	/**
	 * グリッドサイズを設定します
	 * 
	 * @param v グリッドサイズ
	 */
	public void setGridSize(int v) {
		gridSize.setSelection(v);
	}

	/**
	 * グリッドサイズを設定します
	 * 
	 * @return グリッドサイズ
	 */
	public int getGridSize() {
		return gridSize.getSelection();
	}
}
