/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.event;

/**
 * リモートイベント発生時にサーバに送信する要求メッセージを定義
 * するクラスです 
 */
public class Param extends AbstractEventElement {

	/**
	 * SOAP形式による送信（初期値）
	 */
	public static final boolean SOAP_DEFAULT = false;

	/**
	 * HTTP要求メッセージのルートノード名
	 */
	private String rootNode;

	/**
	 * 名前空間
	 */
	private String ns;

	/**
	 * SOAP形式による送信
	 */
	private boolean soap = SOAP_DEFAULT;

	/**
	 * 要求メッセージの有効フラグ
	 */
	private boolean enable;

	/**
	 * デフォルトコンストラクタです
	 */
	public Param() {
		this(true);
	}

	/**
	 * コンストラクタです
	 * 
	 * @param enable メッセージの有効性
	 */
	public Param(boolean enable) {
		this.enable = enable;
	}

	/**
	 * 名前空間を取得します
	 * 
	 * @return 名前空間
	 */
	public String getNs() {
		return ns;
	}

	/**
	 * 名前空間を設定します
	 * 
	 * @param ns 名前空間
	 */
	public void setNs(String ns) {
		this.ns = ns;
	}

	/**
	 * ルートノード名を取得します
	 * 
	 * @return ルートノード名
	 */
	public String getRootNode() {
		return rootNode;
	}

	/**
	 * ルートノード名を設定します
	 * 
	 * @param rootNode ルートノード名
	 */
	public void setRootNode(String rootNode) {
		this.rootNode = rootNode;
	}

	/**
	 * SOAP形式の有効性を判定します
	 * 
	 * @return SOAP形式である場合、true
	 */
	public boolean isSoap() {
		return soap;
	}

	/**
	 * SOAP形式の有効性を設定します
	 * 
	 * @param soap SOAP形式を有効 true
	 */
	public void setSoap(boolean soap) {
		this.soap = soap;
	}

	/**
	 * メッセージの有効性を取得します
	 * 
	 * @return メッセージの有効性を判定します
	 */
	public boolean isEnable() {
		return enable;
	}

	/**
	 * メッセージの有効性を設定します
	 * 
	 * @param enable 有効にする場合、true
	 */
	public void setEnable(boolean enable) {
		this.enable = enable;
	}

	/**
	 * 子要素として持っているSource要素の一覧を配列で取得します
	 * 
	 * @return Source要素の配列
	 */
	public Source[] getSources() {
		return (Source[]) getTypedChildren(Source.class)
				.toArray(new Source[0]);
	}

	/**
	 * 子要素として持っている全てのSource要素を削除します
	 */
	public void removeAllSources() {
		Source[] sources = getSources();
		for (int i = 0; i < sources.length; i++) {
			removeChild(sources[i]);
		}
	}
}

