/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.betwixt;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.betwixt.strategy.NamespacePrefixMapper;

/**
 * 名前空間と名前空間接続詞の対応を保持するクラスです
 * 
 * レイアウト定義XMLで利用される各部品ライブラリの名前空間と名前空間接続詞
 * の対応を保持します。
 * 
 */
public class MaskatNamespacePrefixMapper extends NamespacePrefixMapper {

	/**
	 * デフォルトコンストラクタです
	 */
	MaskatNamespacePrefixMapper() {
		super();
	}
	
	/**
	 *  名前空間と名前空間接続詞の対応マップ
	 */
	private HashMap prefixes = new HashMap();

    /**
     * {@inheritDoc}
     */
	public String getPrefix(String namespaceUri) {
		return super.getPrefix(namespaceUri);
	}

    /**
     * {@inheritDoc}
     */
	public void setPrefix(String namespaceUri, String prefix) {
		prefixes.put(namespaceUri, prefix);
		super.setPrefix(namespaceUri, prefix);
	}

	/**
	 * 名前空間と名前空間接続詞の対応マップを取得します
	 * 
	 * @return 名前空間と名前空間接続詞の対応マップ
	 */
	public Map getPrefixes() {
		return prefixes;
	}
}



