/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.wizards.nature;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import jp.sf.maskat.ui.MaskatNature;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.wizards.nature.AddMaskatNatureCreationPage;
import jp.sf.maskat.ui.wizards.project.PluginResourceData;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class AddMaskatNatureWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    public static final String WIZARD_ID = "jp.sf.maskat.ui.addMaskatNatureWizard";
    private AddMaskatNatureCreationPage mainPage;
    private IProject project;
    private IConfigurationElement configElement;

    public AddMaskatNatureWizard(ISelection selection) {
        IDialogSettings workbenchSettings = MaskatUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("AddMaskatNatureWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("AddMaskatNatureWizard");
        }
        this.setDialogSettings(section);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.getString("wizard.nature.windowTitle"));
        this.setDefaultPageImageDescriptor(MaskatUIPlugin.getImageDescriptor("IMG_WIZBAN_NEWPROJECT"));
        this.project = (IProject)((StructuredSelection)selection).getFirstElement();
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.configElement = config;
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new AddMaskatNatureCreationPage(this.project, (IPath)new Path("./maskat"), true);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        if (this.createNewNature() == null) {
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        return true;
    }

    private IProjectNature createNewNature() {
        final IProject projectHandle = this.project;
        final IPath fwPath = this.mainPage.getMaskatFrameworkPath();
        final boolean copy = this.mainPage.shouldCopyMaskatFramework();
        final PluginResourceData[] plugins = this.mainPage.getSelectedPlugins();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                AddMaskatNatureWizard.this.createProject(projectHandle, monitor, fwPath, copy, plugins);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)ResourceMessages.NewProject_errorMessage, (String)NLS.bind((String)ResourceMessages.NewProject_caseVariantExistsError, (Object)projectHandle.getName()));
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)ResourceMessages.NewProject_errorMessage, null, (IStatus)((CoreException)t).getStatus());
                }
            } else {
                MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 0, t.toString(), t));
                MessageDialog.openError((Shell)this.getShell(), (String)ResourceMessages.NewProject_errorMessage, (String)NLS.bind((String)ResourceMessages.NewProject_internalError, (Object)t.getMessage()));
            }
            return null;
        }
        return MaskatNature.getNature(this.project);
    }

    private void createProject(IProject projectHandle, IProgressMonitor monitor, IPath frameWorkPath, boolean shouldCopy, PluginResourceData[] plugins) throws CoreException, OperationCanceledException {
        block12: {
            try {
                monitor.beginTask("", 3000);
                try {
                    MaskatNature.addNature(projectHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                    MaskatNature nature = MaskatNature.getNature(projectHandle);
                    nature.setMaskatFrameworkPath(frameWorkPath);
                    nature.getPreferenceStore().save();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "jp.sf.maskat.ui", 0, e.getMessage(), (Throwable)e));
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IPath destinationPath = projectHandle.getFullPath().append(frameWorkPath);
                ContainerGenerator generator = new ContainerGenerator(destinationPath);
                IContainer destination = generator.generateContainer((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (!shouldCopy) break block12;
                StringBuffer installPlugins = new StringBuffer();
                int i = 0;
                while (i < plugins.length) {
                    File[] contents = new File(plugins[i].getUrl().getFile()).listFiles();
                    URI[] uris = new URI[contents.length];
                    int j = 0;
                    while (j < contents.length) {
                        uris[j] = contents[j].toURI();
                        ++j;
                    }
                    CopyFilesAndFoldersOperation op = new CopyFilesAndFoldersOperation(this.getShell());
                    op.copyFilesInCurrentThread(uris, destination, (IProgressMonitor)new SubProgressMonitor(monitor, 1000 / plugins.length));
                    if (i != 0) {
                        installPlugins.append(",");
                    }
                    installPlugins.append(plugins[i].getUniqueId());
                    ++i;
                }
                try {
                    MaskatNature nature = MaskatNature.getNature(projectHandle);
                    nature.setInstallWidgetPlugins(installPlugins.toString());
                    nature.getPreferenceStore().save();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "jp.sf.maskat.ui", 0, e.getMessage(), (Throwable)e));
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

