/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.wizards.layout;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.wizards.layout.NewLayoutFileWizardPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewLayoutFileWizard
extends Wizard
implements INewWizard {
    public static final String WIZARD_ID = "jp.sf.maskat.ui.newLayoutFileWizard";
    private NewLayoutFileWizardPage page;
    private ISelection selection;

    public NewLayoutFileWizard() {
        this.setWindowTitle(Messages.getString("wizard.layout.windowtitle"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new NewLayoutFileWizardPage(this.selection);
        ImageDescriptor image = MaskatUIPlugin.getImageDescriptor("IMG_WIZBAN_NEWFILE");
        this.page.setImageDescriptor(image);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        final String layoutName = this.page.getLayoutName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewLayoutFileWizard.this.doFinish(containerName, fileName, layoutName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, String layoutName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException(String.valueOf(containerName) + Messages.getString("wizard.layout.msg.error.notcontainer"));
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream(layoutName);
            if (file.exists()) {
                Object[] msgArgs = new String[]{fileName};
                this.throwCoreException(Messages.format("wizard.layout.msg.error.existfile", msgArgs));
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName(Messages.getString("wizard.layout.taskname"));
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)"jp.sf.maskat.ui.layoutGraphicalEditor", (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private String getTemplate(String templateName) throws IOException {
        InputStream in = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            in = ((Object)((Object)this)).getClass().getResourceAsStream(templateName);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            PrintWriter pw = new PrintWriter(baos);
            String line = null;
            while ((line = reader.readLine()) != null) {
                pw.println(line);
            }
            pw.close();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return baos.toString();
    }

    private InputStream openContentStream(String layoutName) throws UnsupportedEncodingException, IOException {
        String contents = this.getTemplate("layout.template");
        contents = contents.replaceAll("\\Q${layoutName}\\E", layoutName);
        return new ByteArrayInputStream(contents.getBytes("UTF-8"));
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "jp.sf.maskat.ui", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

