/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.wizards.application;

import java.io.File;
import java.util.ArrayList;
import jp.sf.maskat.ui.MaskatNature;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class NewMaskatApplicationWizardPage
extends WizardPage {
    public static final String DEFAULT_APPLICATION_NAME = "";
    public static final String DEFAULT_HTML_TITLE_NAME = "New Maskat Application";
    private Text directory;
    private Text applicationName;
    private Text htmlTitle;
    private ISelection selection;
    private CheckboxTableViewer viewer;

    public NewMaskatApplicationWizardPage(String pageName, ISelection selection) {
        super(pageName);
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label dirLabel = new Label(composite, 0);
        dirLabel.setText(Messages.getString("wizard.application.label.dir"));
        this.directory = new Text(composite, 2048);
        this.directory.setLayoutData((Object)new GridData(768));
        this.directory.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMaskatApplicationWizardPage.this.setPageComplete(NewMaskatApplicationWizardPage.this.validatePage());
            }
        });
        Button button = new Button(composite, 8);
        button.setText(Messages.getString("wizard.application.button.browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewMaskatApplicationWizardPage.this.handleBrowse();
            }
        });
        Label appLabel = new Label(composite, 0);
        appLabel.setText(Messages.getString("wizard.application.label.appname"));
        this.applicationName = new Text(composite, 2048);
        GridData appGridData = new GridData(768);
        appGridData.horizontalSpan = 2;
        this.applicationName.setLayoutData((Object)appGridData);
        this.applicationName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMaskatApplicationWizardPage.this.setPageComplete(NewMaskatApplicationWizardPage.this.validatePage());
            }
        });
        Label htmlLabel = new Label(composite, 0);
        htmlLabel.setText(Messages.getString("wizard.application.label.title"));
        this.htmlTitle = new Text(composite, 2048);
        GridData htmlGridData = new GridData(768);
        htmlGridData.horizontalSpan = 2;
        this.htmlTitle.setLayoutData((Object)htmlGridData);
        this.htmlTitle.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMaskatApplicationWizardPage.this.setPageComplete(NewMaskatApplicationWizardPage.this.validatePage());
            }
        });
        Label createLabel = new Label(composite, 0);
        GridData crGridData = new GridData(2);
        crGridData.horizontalSpan = 3;
        this.applicationName.setLayoutData((Object)appGridData);
        createLabel.setText(Messages.getString("wizard.application.label.createfile"));
        this.viewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)67584);
        Table table = this.viewer.getTable();
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn typeColumn = new TableColumn(table, 0x1000000);
        typeColumn.setText(Messages.getString("wizard.application.label.type"));
        typeColumn.setWidth(180);
        TableColumn nameColumn = new TableColumn(table, 16384);
        nameColumn.setText(Messages.getString("wizard.application.label.filename"));
        nameColumn.setWidth(120);
        TableColumn discColumn = new TableColumn(table, 16384);
        discColumn.setText(Messages.getString("wizard.application.label.description"));
        discColumn.setWidth(200);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new CreateFileListLabelProvider());
        this.viewer.setInput(this.createTableObjects());
        this.viewer.setAllChecked(true);
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[1] = new TextCellEditor((Composite)table);
        this.viewer.setCellEditors(cellEditorArray);
        this.viewer.setColumnProperties(new String[]{"summary", "fileName", "description"});
        this.viewer.setCellModifier((ICellModifier)new CreateFileCellModifier((TableViewer)this.viewer));
        this.setControl((Control)composite);
        this.initialize();
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.directory.setText(container.getFullPath().toString());
            }
        }
        this.applicationName.setText(DEFAULT_APPLICATION_NAME);
        this.htmlTitle.setText(DEFAULT_HTML_TITLE_NAME);
    }

    private Object createTableObjects() {
        return new CreateFileData[]{new CreateFileData("container", Messages.getString("wizard.application.container.filename"), "index.html", null, Messages.getString("wizard.application.container.description")), new CreateFileData("transition", Messages.getString("wizard.application.transition.filename"), "transition.xml", "xml", Messages.getString("wizard.application.transition.description")), new CreateFileData("layout", Messages.getString("wizard.application.layout.filename"), "layout.xml", "xml", Messages.getString("wizard.application.layout.description")), new CreateFileData("event", Messages.getString("wizard.application.event.filename"), "layout_e.xml", "xml", Messages.getString("wizard.application.event.description"))};
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, Messages.getString("wizard.application.browse.title"));
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.directory.setText(((Path)result[0]).toString());
        }
    }

    public void dispose() {
        super.dispose();
    }

    private boolean validatePage() {
        String dirPath = this.directory.getText();
        if (dirPath == null || dirPath.length() == 0) {
            this.setErrorMessage(Messages.getString("wizard.application.msg.error.notdir"));
            this.directory.setFocus();
            this.directory.selectAll();
            return false;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource dir = root.findMember((IPath)new Path(dirPath));
        if (dir == null || !dir.exists()) {
            Object[] msgArgs = new String[]{this.directory.getText()};
            this.setErrorMessage(Messages.format("wizard.application.msg.error.notexistdir", msgArgs));
            this.directory.setFocus();
            return false;
        }
        IProject project = dir.getProject();
        if (project == null || MaskatNature.getNature(project) == null) {
            Object[] msgArgs = new String[]{this.directory.getText()};
            this.setErrorMessage(Messages.format("wizard.application.msg.error.invalidproject", msgArgs));
            this.directory.setFocus();
            return false;
        }
        String appName = this.applicationName.getText();
        if (appName == null || appName.length() == 0) {
            this.setErrorMessage(Messages.getString("wizard.application.msg.error.notapp"));
            this.applicationName.setFocus();
            return false;
        }
        IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
        IStatus nameStatus = workspace.validateName(appName, 2);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            this.applicationName.setFocus();
            return false;
        }
        StringBuffer sb = new StringBuffer(dirPath);
        sb.append(File.separator).append(appName);
        IResource app = root.findMember((IPath)new Path(sb.toString()));
        if (app != null && app.exists()) {
            Object[] msgArgs = new String[]{appName};
            this.setErrorMessage(Messages.format("wizard.application.msg.error.alreadyexists.app", msgArgs));
            this.applicationName.setFocus();
            return false;
        }
        String title = this.htmlTitle.getText();
        if (title == null || title.length() == 0) {
            this.setErrorMessage(Messages.getString("wizard.application.msg.error.nothtml"));
            this.htmlTitle.setFocus();
            return false;
        }
        ArrayList<String> nameList = new ArrayList<String>();
        CreateFileData[] datas = (CreateFileData[])this.viewer.getInput();
        int i = 0;
        while (i < datas.length) {
            String name = datas[i].fileName;
            if (name == null || name.length() == 0) {
                this.setErrorMessage(Messages.getString("wizard.application.msg.error.notfilename"));
                this.viewer.getTable().setFocus();
                return false;
            }
            IStatus status = workspace.validateName(name, 1);
            if (!status.isOK()) {
                this.setErrorMessage(status.getMessage());
                this.viewer.getTable().setFocus();
                return false;
            }
            int dotLoc = name.lastIndexOf(46);
            if (dotLoc != -1) {
                String ext = name.substring(dotLoc + 1);
                if (datas[i].extension != null && !ext.equalsIgnoreCase(datas[i].extension)) {
                    this.setErrorMessage(Messages.getString("wizard.application.msg.error.filename.invalidextension"));
                    this.viewer.getTable().setFocus();
                    return false;
                }
            } else if (datas[i].extension != null) {
                this.setErrorMessage(Messages.getString("wizard.application.msg.error.filename.invalidextension"));
                this.viewer.getTable().setFocus();
                return false;
            }
            if (nameList.contains(name)) {
                Object[] msgArgs = new String[]{name};
                this.setErrorMessage(Messages.format("wizard.application.msg.error.filename.samename", msgArgs));
                this.viewer.getTable().setFocus();
                return false;
            }
            nameList.add(name);
            ++i;
        }
        this.setErrorMessage(null);
        return true;
    }

    public String getDirectory() {
        return this.directory.getText();
    }

    public String getApplicationName() {
        return this.applicationName.getText();
    }

    public String getHtmlTitle() {
        return this.htmlTitle.getText();
    }

    public String getContainerFileName() {
        return this.getCreateFileData((String)"container").fileName;
    }

    public String getTransitionFileName() {
        return this.getCreateFileData((String)"transition").fileName;
    }

    public String getLayoutFileName() {
        return this.getCreateFileData((String)"layout").fileName;
    }

    public String getEventFileName() {
        return this.getCreateFileData((String)"event").fileName;
    }

    public boolean isSelectedContainerFile() {
        return this.getSelectedFileName("container");
    }

    public boolean isSelectedTransitionFile() {
        return this.getSelectedFileName("transition");
    }

    public boolean isSelectedLayoutFile() {
        return this.getSelectedFileName("layout");
    }

    public boolean isSelectedEventFile() {
        return this.getSelectedFileName("event");
    }

    private boolean getSelectedFileName(String key) {
        Object[] select = this.viewer.getCheckedElements();
        if (select != null) {
            int i = 0;
            while (i < select.length) {
                if (key.equals(((CreateFileData)select[i]).propertyName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private CreateFileData getCreateFileData(String key) {
        CreateFileData[] data = (CreateFileData[])this.viewer.getInput();
        int i = 0;
        while (i < data.length) {
            if (key.equals(data[i].propertyName)) {
                return data[i];
            }
            ++i;
        }
        return null;
    }

    private String getEventFileName(String layoutName) {
        String[] v = layoutName.split("\\.");
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < v.length) {
            if (i == v.length - 1) {
                sb.append("_e.");
            }
            sb.append(v[i]);
            ++i;
        }
        return sb.toString();
    }

    public class CreateFileCellModifier
    implements ICellModifier {
        private TableViewer viewer;

        public CreateFileCellModifier(TableViewer viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            if ("fileName".equals(property)) {
                CreateFileData data = (CreateFileData)element;
                return !"event".equals(data.propertyName);
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            CreateFileData data = (CreateFileData)element;
            if ("summary".equals(property)) {
                return data.summary;
            }
            if ("fileName".equals(property)) {
                return data.fileName;
            }
            if ("description".equals(property)) {
                return data.description;
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            if ("fileName".equals(property)) {
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                CreateFileData data = (CreateFileData)element;
                data.fileName = (String)value;
                this.viewer.update(element, null);
                if ("layout".equals(data.propertyName)) {
                    CreateFileData d = NewMaskatApplicationWizardPage.this.getCreateFileData("event");
                    d.fileName = NewMaskatApplicationWizardPage.this.getEventFileName(data.fileName);
                    this.viewer.update((Object)d, null);
                }
                NewMaskatApplicationWizardPage.this.setPageComplete(NewMaskatApplicationWizardPage.this.validatePage());
            }
        }
    }

    private class CreateFileData {
        public String propertyName;
        public String summary;
        public String fileName;
        public String extension;
        public String description;

        public CreateFileData(String p, String s, String f, String e, String d) {
            this.propertyName = p;
            this.summary = s;
            this.fileName = f;
            this.extension = e;
            this.description = d;
        }
    }

    public class CreateFileListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Image maskatImage = MaskatUIPlugin.getImage("IMG_WIZBAN_MASKATFILE");
        private Image htmlImage = MaskatUIPlugin.getImage("IMG_WIZBAN_HTMLFILE");

        public Image getColumnImage(Object element, int columnIndex) {
            Image img = null;
            if (columnIndex == 0) {
                CreateFileData data = (CreateFileData)element;
                img = "container".equals(data.propertyName) ? this.htmlImage : this.maskatImage;
            }
            return img;
        }

        public String getColumnText(Object element, int columnIndex) {
            CreateFileData data = (CreateFileData)element;
            switch (columnIndex) {
                case 0: {
                    return data.summary;
                }
                case 1: {
                    return data.fileName;
                }
                case 2: {
                    return data.description;
                }
            }
            return null;
        }
    }
}

