/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.wizards.application;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import jp.sf.maskat.ui.MaskatNature;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.wizards.application.NewMaskatApplicationWizardPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewMaskatApplicationWizard
extends Wizard
implements INewWizard {
    public static final String WIZARD_ID = "jp.sf.maskat.ui.newMaskatApplicationWizard";
    private NewMaskatApplicationWizardPage page;
    private IStructuredSelection selection;

    public NewMaskatApplicationWizard() {
        this.setWindowTitle(Messages.getString("wizard.application.windowTitle"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new NewMaskatApplicationWizardPage("createMaskatApplication", (ISelection)this.selection);
        this.page.setTitle(Messages.getString("wizard.application.tilte"));
        this.page.setDescription(Messages.getString("wizard.application.description"));
        ImageDescriptor image = MaskatUIPlugin.getImageDescriptor("IMG_WIZBAN_NEWAPP");
        this.page.setImageDescriptor(image);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource dir = root.findMember((IPath)new Path(this.page.getDirectory()));
        MaskatNature nature = MaskatNature.getNature(dir.getProject());
        String maskatFWPath = nature.getMaskatFrameworkPath().removeTrailingSeparator().toString();
        maskatFWPath = maskatFWPath.startsWith("./") ? "." + maskatFWPath : (maskatFWPath.startsWith("/") ? ".." + maskatFWPath : "../" + maskatFWPath);
        final ApplicationParam param = new ApplicationParam(maskatFWPath, this.page.getDirectory(), this.page.getApplicationName(), this.page.getHtmlTitle(), this.page.isSelectedContainerFile(), this.page.getContainerFileName(), this.page.isSelectedTransitionFile(), this.page.getTransitionFileName(), this.page.isSelectedLayoutFile(), this.page.getLayoutFileName(), this.page.isSelectedEventFile(), this.page.getEventFileName());
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewMaskatApplicationWizard.this.doFinish(param, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("wizard.application.errdialog.title"), (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void createFile(IFile file, String value) throws CoreException {
        block16: {
            InputStream stream = null;
            try {
                try {
                    stream = new ByteArrayInputStream(value.getBytes("UTF-8"));
                    if (file.exists()) {
                        this.throwCoreException(Messages.getString("wizard.application.msg.error.alreadyexists"));
                    } else {
                        file.create(stream, true, null);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    this.throwCoreException(e.getMessage());
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void doFinish(ApplicationParam param, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.getString("wizard.application.tasktext"), 5);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(param.directory));
        IContainer container = (IContainer)resource;
        IFolder folder = container.getFolder((IPath)new Path(param.applicationName));
        folder.create(false, true, null);
        monitor.worked(1);
        String path = String.valueOf(param.applicationName) + File.separator;
        try {
            if (param.selectedContainer) {
                this.createFile(container.getFile((IPath)new Path(String.valueOf(path) + param.containerFileName)), this.replaceParamater(param, this.getTemplate("container.template")));
            }
            monitor.worked(1);
            if (param.selectedLayout) {
                this.createFile(container.getFile((IPath)new Path(String.valueOf(path) + param.layoutFileName)), this.getTemplate("layout.template"));
            }
            monitor.worked(1);
            if (param.selectedTransition) {
                this.createFile(container.getFile((IPath)new Path(String.valueOf(path) + param.transitionFileName)), this.replaceParamater(param, this.getTemplate("transition.template")));
            }
            monitor.worked(1);
            if (param.selectedEvent) {
                this.createFile(container.getFile((IPath)new Path(String.valueOf(path) + param.eventFileName)), this.getTemplate("event.template"));
            }
            monitor.worked(1);
        }
        catch (IOException e) {
            this.throwCoreException(e.getMessage());
        }
        monitor.done();
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "jp.sf.maskat.ui", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    private String getTemplate(String templateName) throws IOException {
        InputStream in = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            in = ((Object)((Object)this)).getClass().getResourceAsStream(templateName);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            PrintWriter pw = new PrintWriter(baos);
            String line = null;
            while ((line = reader.readLine()) != null) {
                pw.println(line);
            }
            pw.close();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return baos.toString();
    }

    private String replaceParamater(ApplicationParam param, String value) {
        String title = param.htmlTitle.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;");
        String v = value.replaceAll("\\Q${title}\\E", title).replaceAll("\\Q${maskatFWPath}\\E", param.maskatFWPath).replaceAll("\\Q${layoutFileName}\\E", param.layoutFileName).replaceAll("\\Q${eventFileName}\\E", param.eventFileName);
        return v;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    private class ApplicationParam {
        public String maskatFWPath;
        public String directory;
        public String applicationName;
        public String htmlTitle;
        public String containerFileName;
        public String transitionFileName;
        public String layoutFileName;
        public String eventFileName;
        public boolean selectedContainer;
        public boolean selectedTransition;
        public boolean selectedLayout;
        public boolean selectedEvent;

        public ApplicationParam(String path, String dir, String app, String title, boolean isCont, String container, boolean isTrans, String transition, boolean isLayout, String layout, boolean isEvent, String event) {
            this.maskatFWPath = path;
            this.directory = dir;
            this.applicationName = app;
            this.htmlTitle = title;
            this.containerFileName = container;
            this.transitionFileName = transition;
            this.layoutFileName = layout;
            this.eventFileName = event;
            this.selectedContainer = isCont;
            this.selectedTransition = isTrans;
            this.selectedLayout = isLayout;
            this.selectedEvent = isEvent;
        }
    }
}

