/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper;

import java.util.ArrayList;
import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.views.properties.tabbed.action.DeleteOneNodeAction;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;

public class AbstractTreeNode
implements ITreeNode {
    private static final String DISPLAY_TEXT = Messages.getString("abstractTreeNode.displayText");
    protected MaskatElement maskatElement;
    private ITreeNode parent;
    private ArrayList children = new ArrayList();

    public AbstractTreeNode(MaskatElement maskatElement) {
        this.maskatElement = maskatElement;
        if (maskatElement != null) {
            this.loadChildren();
        }
    }

    public void setModel(MaskatElement model) {
        this.maskatElement = model;
    }

    public MaskatElement getModel() {
        return this.maskatElement;
    }

    public String getImage() {
        return null;
    }

    public String getDisplayText() {
        return DISPLAY_TEXT;
    }

    public IMenuManager fillContextMenu(TreeViewer treeViewer, IMenuManager manager) {
        if (this.isDeletable()) {
            if (manager.getItems().length > 0) {
                manager.add((IContributionItem)new Separator());
            }
            manager.add((IAction)new DeleteOneNodeAction(treeViewer, this));
        }
        return manager;
    }

    public void addChild(ITreeNode child) {
        if (this.children.contains(child)) {
            return;
        }
        this.children.add(child);
        child.setParent(this);
    }

    public ITreeNode getParent() {
        return this.parent;
    }

    public void setParent(ITreeNode parent) {
        this.parent = parent;
    }

    public Object[] getChildren() {
        return this.children.toArray();
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public void clearChildren() {
        this.children.clear();
    }

    public void removeChild(ITreeNode child) {
        this.children.remove(child);
        child.setParent(null);
    }

    public boolean containsChild(Class childClass) {
        int i = 0;
        while (i < this.children.size()) {
            if (childClass.equals(this.children.get(i).getClass())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isDeletable() {
        return true;
    }

    public boolean isCopiable() {
        return false;
    }

    public boolean canPasteTo(ITreeNode parent) {
        return false;
    }

    protected void loadChildren() {
    }
}

