/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.views.properties.tabbed.beanwrapper;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.event.Bind;
import jp.sf.maskat.core.event.Source;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.ParamTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.SourceBind;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.SourceChildNode;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.Validation;
import jp.sf.maskat.ui.views.properties.tabbed.command.AddTreeNodeCommand;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.AbstractTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;

public class SourceNode
extends AbstractTreeNode {
    private static final String MULTI_LABEL = Messages.getString("sourceNode.multiValueLabel");
    private static final String SINGLE_LABEL = Messages.getString("sourceNode.singleValueLabel");
    private static final String ADD_SOURCE_CHILD_NODE = Messages.getString("sourceNode.addSourceChildNode");
    private static final String ADD_SOURCE_BIND_NODE = Messages.getString("sourceNode.addSourceBindNode");
    private static final String ADD_VALIDATION = Messages.getString("sourceNode.addValidation");

    public SourceNode(Source source) {
        super((MaskatElement)source);
    }

    protected void loadChildren() {
        Source source = (Source)this.maskatElement;
        if (source.getChildNode() != null) {
            this.addChild(new SourceChildNode(source));
        } else {
            Bind[] binds = source.getBinds();
            int i = 0;
            while (i < binds.length) {
                this.addChild(new SourceBind(binds[i]));
                ++i;
            }
        }
        if (source.getType() != null) {
            this.addChild(new Validation(source));
        }
    }

    public void removeChild(ITreeNode child) {
        super.removeChild(child);
        if (child instanceof Validation) {
            ((Source)this.maskatElement).setType(null);
            ((Source)this.maskatElement).setDesc(null);
            ((Source)this.maskatElement).setMin(-1);
            ((Source)this.maskatElement).setMax(-1);
            ((Source)this.maskatElement).setRegexp(null);
        } else if (child instanceof SourceChildNode) {
            ((Source)this.maskatElement).setChildNode(null);
            this.moveSourceBindNodes(child, this);
        } else if (child instanceof SourceBind) {
            ((Source)this.maskatElement).removeChild((Object)child.getModel());
        }
    }

    public void addChild(ITreeNode child) {
        super.addChild(child);
        if (child instanceof Validation) {
            if (((Source)this.maskatElement).getType() == null) {
                ((Source)this.maskatElement).setType("");
            }
        } else if (child instanceof SourceChildNode) {
            if (((Source)this.maskatElement).getChildNode() == null) {
                ((Source)this.maskatElement).setChildNode("");
            }
            this.moveSourceBindNodes(this, child);
            ((Source)this.maskatElement).setFromkey("");
        } else if (child instanceof SourceBind) {
            this.maskatElement.addChild((Object)child.getModel());
            if (this.containsChild(SourceChildNode.class)) {
                this.moveSourceBindNodes(this, this.getSourceChildNode());
            }
            if (((Source)this.maskatElement).getChildNode() != null) {
                ((Source)this.maskatElement).setFromkey("");
            }
        }
    }

    private ITreeNode getSourceChildNode() {
        Object[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof SourceChildNode) {
                return (ITreeNode)children[i];
            }
            ++i;
        }
        return null;
    }

    private void moveSourceBindNodes(ITreeNode oldParent, ITreeNode newParent) {
        Object[] sourceBinds = oldParent.getChildren();
        int i = 0;
        while (i < sourceBinds.length) {
            if (sourceBinds[i] instanceof SourceBind) {
                oldParent.removeChild((ITreeNode)sourceBinds[i]);
                if (!this.sameBindExists(newParent, (ITreeNode)sourceBinds[i])) {
                    newParent.addChild((ITreeNode)sourceBinds[i]);
                }
                this.maskatElement.addChild((Object)((ITreeNode)sourceBinds[i]).getModel());
            }
            ++i;
        }
    }

    private boolean sameBindExists(ITreeNode parent, ITreeNode child) {
        Object[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            if (((ITreeNode)children[i]).getModel() == child.getModel()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getDisplayText() {
        Source source = (Source)this.maskatElement;
        if (source.getNode() == null || source.getNode().length() == 0) {
            if (source.getChildNode() != null) {
                return MULTI_LABEL;
            }
            return SINGLE_LABEL;
        }
        if (source.getChildNode() != null) {
            return String.valueOf(source.getNode()) + " " + MULTI_LABEL;
        }
        return String.valueOf(source.getNode()) + " " + SINGLE_LABEL;
    }

    public IMenuManager fillContextMenu(final TreeViewer treeViewer, IMenuManager manager) {
        final SourceNode node = this;
        final Source source = (Source)this.maskatElement;
        if (!node.containsChild(SourceChildNode.class)) {
            manager.add((IAction)new Action(ADD_SOURCE_CHILD_NODE){

                public void run() {
                    source.setChildNode("");
                    SourceChildNode childNode = new SourceChildNode(source);
                    EventPropertiesMasterDetailsBlock.executeCommand(new AddTreeNodeCommand(treeViewer, node, childNode));
                }
            });
        }
        if (!node.containsChild(SourceChildNode.class)) {
            manager.add((IAction)new Action(ADD_SOURCE_BIND_NODE){

                public void run() {
                    Bind bind = new Bind();
                    SourceBind childNode = new SourceBind(bind);
                    EventPropertiesMasterDetailsBlock.executeCommand(new AddTreeNodeCommand(treeViewer, node, childNode));
                }
            });
        }
        if (!node.containsChild(Validation.class)) {
            manager.add((IAction)new Action(ADD_VALIDATION){

                public void run() {
                    source.setType("");
                    Validation childNode = new Validation(source);
                    EventPropertiesMasterDetailsBlock.executeCommand(new AddTreeNodeCommand(treeViewer, node, childNode));
                }
            });
        }
        return super.fillContextMenu(treeViewer, manager);
    }

    public boolean isCopiable() {
        return true;
    }

    public boolean canPasteTo(ITreeNode parent) {
        return parent != null && parent instanceof ParamTreeNode;
    }
}

