/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.views.properties.tabbed;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import jp.sf.maskat.core.event.Event;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.EventTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class EventPropertySection
extends AbstractPropertySection
implements PropertyChangeListener,
IExecutableExtension {
    private static final String SECTION_TEXT = Messages.getString("eventPropertySection.sectionText");
    private String eventType;
    private Component component;
    private FormToolkit toolkit;
    private ScrolledForm form;
    private ManagedForm managedForm;
    private EventPropertiesMasterDetailsBlock block;
    private Composite parent;
    private GraphicalViewer graphicalViewer = null;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.parent = parent;
        this.toolkit = this.getWidgetFactory();
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.setText(SECTION_TEXT);
        this.managedForm = new ManagedForm(this.toolkit, this.form);
        this.block = new EventPropertiesMasterDetailsBlock();
        this.block.createContent((IManagedForm)this.managedForm);
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void setFocus() {
        this.form.setFocus();
    }

    public void dispose() {
        if (this.component != null) {
            this.component.removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.dispose();
    }

    public void refresh() {
        Object element;
        if (this.component != null) {
            this.component.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.component = null;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (element = ((IStructuredSelection)selection).getFirstElement()) != null && element instanceof EditPart) {
            Object model = ((EditPart)element).getModel();
            if (model instanceof Component) {
                this.component = (Component)model;
            }
            this.component.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.renew();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("#event".equals(evt.getPropertyName())) {
            Event event = (Event)evt.getNewValue();
            if (event.isEnable()) {
                TreeViewer viewer = this.block.getTreeViewer();
                EventPropertiesMasterDetailsBlock.setEventProperty(viewer, EventTreeNode.class, event, "type", event.getType());
                EventPropertiesMasterDetailsBlock.setEventProperty(viewer, EventTreeNode.class, event, "enable", "true");
            }
            this.block.refresh(event);
        }
    }

    private void renew() {
        if (this.block.getTreeViewer() == null || this.block.getTreeViewer().getContentProvider() == null) {
            this.form.dispose();
            this.form = this.toolkit.createScrolledForm(this.parent);
            this.form.setText(SECTION_TEXT);
            this.managedForm = new ManagedForm(this.toolkit, this.form);
            this.block = new EventPropertiesMasterDetailsBlock();
            this.block.createContent((IManagedForm)this.managedForm);
            this.block.setCommandStack((CommandStack)this.getPart().getAdapter(CommandStack.class));
            this.form.setSize(this.parent.getBounds().width - 5, this.parent.getBounds().height - 10);
            this.form.pack(true);
        }
        if (this.component != null) {
            String type = this.eventType.substring(this.eventType.lastIndexOf(".") + 1);
            Event event = this.component.getEvent(type);
            if (event == null) {
                this.component.setEvent(new Event(type));
            } else {
                this.block.refresh(event);
            }
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.graphicalViewer = (GraphicalViewer)part.getAdapter(GraphicalViewer.class);
        this.block.setGraphicalViewer(this.graphicalViewer);
        this.block.setCommandStack((CommandStack)part.getAdapter(CommandStack.class));
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String sectionId;
        this.eventType = sectionId = config.getAttribute("id");
    }
}

