/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.views.properties.descriptor;

import jp.sf.maskat.ui.views.properties.descriptor.Category;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;

public class BooleanComboBoxPropertyDescriptor
extends ComboBoxPropertyDescriptor {
    private static String FALSE = "false";
    private static String TRUE = "true";
    private static String[] labels = new String[]{FALSE, TRUE};

    private static int indexOfLabel(String item) {
        int i = 0;
        while (i < labels.length) {
            if (item.equals(labels[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public BooleanComboBoxPropertyDescriptor(Object id, String displayName) {
        super(id, displayName, labels);
        this.setLabelProvider((ILabelProvider)new BooleanLabelProvider());
        this.setCategory(Category.getCategory(displayName));
    }

    public CellEditor createPropertyEditor(Composite parent) {
        BooleanComboBoxCellEditor editor = new BooleanComboBoxCellEditor(parent, labels, 8);
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }

    private static class BooleanComboBoxCellEditor
    extends ComboBoxCellEditor {
        public BooleanComboBoxCellEditor(Composite parent, String[] items, int style) {
            super(parent, items, style);
        }

        protected void doSetValue(Object value) {
            value = TRUE.equals(value) || (Boolean)value != false ? new Integer(BooleanComboBoxPropertyDescriptor.indexOfLabel(TRUE)) : new Integer(BooleanComboBoxPropertyDescriptor.indexOfLabel(FALSE));
            super.doSetValue(value);
        }
    }

    private static class BooleanLabelProvider
    extends LabelProvider {
        private BooleanLabelProvider() {
        }

        public String getText(Object element) {
            return element.toString();
        }
    }
}

