/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.preview;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import jp.sf.maskat.core.MaskatElementVisitor;
import jp.sf.maskat.core.betwixt.MaskatBeanIO;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.LayoutDef;
import jp.sf.maskat.runtime.MaskatRuntimePlugin;
import jp.sf.maskat.ui.MaskatNature;
import jp.sf.maskat.ui.Messages;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class LayoutPreviewBrowser
extends EditorPart {
    public static final String EDITOR_ID = "jp.sf.maskat.ui.layoutPreviewBrowser";
    private Browser browser;

    public void createPartControl(Composite parent) {
        ScrolledComposite composite = new ScrolledComposite(parent, 768);
        composite.setLayout((Layout)new FillLayout());
        composite.setExpandHorizontal(true);
        composite.setExpandVertical(true);
        this.browser = new Browser((Composite)composite, 0);
        composite.setContent((Control)this.browser);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    public void setFocus() {
        try {
            this.browser.setUrl(this.generateContents().toString());
        }
        catch (Exception exception) {
            this.browser.setText(Messages.getString("preview.create.msg.error"));
        }
        this.browser.setFocus();
    }

    private URL generateContents() throws IOException, CoreException {
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        String frameworkBase = MaskatRuntimePlugin.getFrameworkBaseURL().toString();
        try {
            MaskatNature nature = MaskatNature.getNature(file.getProject());
            if (nature != null) {
                URI uri = nature.getProject().getLocationURI();
                String fwPath = nature.getMaskatFrameworkPath().toString();
                if (fwPath != null && !fwPath.startsWith("/")) {
                    fwPath = "/" + fwPath;
                }
                uri = new URI(String.valueOf(uri.toString()) + fwPath + "/");
                frameworkBase = FileLocator.toFileURL((URL)uri.toURL()).toString();
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
        InputStream in = null;
        final Rectangle rec = this.browser.getBounds();
        try {
            try {
                in = file.getContents(true);
                LayoutDef layoutDef = MaskatBeanIO.readLayoutDef((InputStream)in);
                layoutDef.getLayouts()[0].accept(new MaskatElementVisitor(){

                    public void visit(Object def) {
                        if (def instanceof Component) {
                            Component comp = (Component)def;
                            rec.width = Math.max(rec.width, comp.getLeft() + comp.getWidth() + 50);
                            rec.height = Math.max(rec.height, comp.getTop() + comp.getHeight() + 50);
                        }
                    }
                });
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        ((ScrolledComposite)this.browser.getParent()).setMinSize(rec.width, rec.height);
        File idxFile = File.createTempFile("_maskat", "idx");
        File tmpFolder = new File(idxFile.getParentFile().getAbsoluteFile(), "_maskat");
        tmpFolder.mkdir();
        tmpFolder.deleteOnExit();
        idxFile.delete();
        InputStream containerIn = null;
        BufferedOutputStream containerOut = null;
        File containerFile = null;
        try {
            containerFile = new File(tmpFolder, "preview.html");
            containerFile.createNewFile();
            containerFile.deleteOnExit();
            containerOut = new BufferedOutputStream(new FileOutputStream(containerFile));
            containerIn = ((Object)((Object)this)).getClass().getResourceAsStream("preview.html");
            String html = IOUtils.toString((InputStream)containerIn, (String)"UTF-8");
            ((OutputStream)containerOut).write(html.replaceAll("\\Q${maskatFW}\\E", frameworkBase).getBytes("UTF-8"));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(containerIn);
            IOUtils.closeQuietly(containerOut);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)containerIn);
        IOUtils.closeQuietly((OutputStream)containerOut);
        this.copyFile(file, new File(tmpFolder, "layout.xml"));
        this.copyFile("layout_e.xml", new File(tmpFolder, "layout_e.xml"));
        this.copyFile("transition.xml", new File(tmpFolder, "transition.xml"));
        String path = file.getParent().getName();
        try {
            IFile jsonResouce = file.getProject().getFile(String.valueOf(path) + "/properties.json");
            this.copyFile(jsonResouce, new File(tmpFolder, "properties.json"));
        }
        catch (CoreException coreException) {}
        return containerFile != null ? containerFile.toURL() : null;
    }

    private void copyFile(String resourceName, File createFile) throws IOException {
        this.copyFile(((Object)((Object)this)).getClass().getResourceAsStream(resourceName), createFile);
    }

    private void copyFile(IFile resource, File createFile) throws IOException, CoreException {
        this.copyFile(resource.getContents(true), createFile);
    }

    private void copyFile(InputStream in, File createFile) throws IOException {
        BufferedOutputStream out = null;
        try {
            if (in != null) {
                createFile.createNewFile();
                createFile.deleteOnExit();
                out = new BufferedOutputStream(new FileOutputStream(createFile));
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly(out);
        }
    }
}

