/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout.tools;

import jp.sf.maskat.ui.editors.layout.requests.DataBindingRequest;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.ISimpleCallbackInterface;
import org.eclipse.draw2d.Cursors;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.tools.TargetingTool;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.swt.graphics.Cursor;

public class DataBindingTool
extends TargetingTool {
    ISimpleCallbackInterface callbackReference;
    protected Object bean;
    protected String propertyName;
    private Cursor defaultCursor;

    public DataBindingTool(Object bean, String propertyName) {
        this.bean = bean;
        this.propertyName = propertyName;
        this.defaultCursor = this.getDefaultCursor();
        this.setDefaultCursor(Cursors.HAND);
        this.setDisabledCursor(Cursors.NO);
    }

    public void registerCallback(ISimpleCallbackInterface callbackRefrence) {
        this.callbackReference = callbackRefrence;
    }

    protected Request createTargetRequest() {
        return new DataBindingRequest(this.bean, this.propertyName);
    }

    protected String getCommandName() {
        return "data binding";
    }

    protected Cursor calculateCursor() {
        if (this.isInState(1) && this.getTargetEditPart() != null) {
            return this.getDefaultCursor();
        }
        if (this.getCurrentViewer() instanceof TreeViewer) {
            return Cursors.ARROW;
        }
        return this.getDisabledCursor();
    }

    protected boolean handleMove() {
        if (this.isInState(1)) {
            this.updateTargetUnderMouse();
            this.setCurrentCommand(this.getCommand());
        }
        return true;
    }

    protected boolean handleButtonDown(int button) {
        if (this.stateTransition(1, 0x40000000)) {
            Command command = this.getCommand();
            if (command != null && command.canExecute()) {
                this.setCurrentCommand(command);
                this.executeCurrentCommand();
            }
            this.releaseToolCapture();
            this.setDefaultCursor(this.defaultCursor);
            this.callbackReference.callback(true);
            return true;
        }
        this.callbackReference.callback(false);
        return false;
    }
}

