/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout.editpolicies;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.editors.layout.editpolicies.DiagramAssistantEditPolicy;
import jp.sf.maskat.ui.editors.layout.editpolicies.PopupBarDescriptor;
import jp.sf.maskat.ui.editors.layout.editpolicies.PopupBarDescriptorRegistory;
import jp.sf.maskat.ui.editors.layout.tools.PopupBarTool;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Tool;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class PopupBarEditPolicy
extends DiagramAssistantEditPolicy {
    public static final String ROLE = "popupbar";
    private static Image IMAGE_POPUPBAR_PLUS = MaskatUIPlugin.getImage("IMAGE_POPUPBAR_PLUS");
    private static Image IMAGE_POPUPBAR = MaskatUIPlugin.getImage("IMAGE_POPUPBAR");
    private static int BALLOON_Y_OFFSET = 10;
    private static double BALLOON_X_OFFSET_RHS = 0.65;
    private static double BALLOON_X_OFFSET_LHS = 0.25;
    private static int ACTION_WIDTH_HGT = 30;
    private static int ACTION_BUTTON_START_X = 5;
    private static int ACTION_BUTTON_START_Y = 5;
    private static int ACTION_MARGIN_RIGHT = 10;
    private static int POPUPBAR_ACTIVATEONHOVER = 1;
    private static int POPUPBAR_MOVE_FIGURE = 2;
    private static int POPUPBAR_DISPLAYATMOUSEHOVERLOCATION = 4;
    private static int POPUPBAR_ONDIAGRAMACTIVATED = 16;
    private static int POPUPBAR_HOST_IS_CONNECTION = 32;
    private int myPopupBarFlags = POPUPBAR_ACTIVATEONHOVER;
    private double myBallonOffsetPercent = BALLOON_X_OFFSET_RHS;
    private IFigure myBalloon = null;
    private List myPopupBarDescriptors = new ArrayList();
    protected List imagesToBeDisposed = null;
    private PopupBarMouseListener myMouseKeyListener = new PopupBarMouseListener();
    private OwnerMovedListener myOwnerMovedListener = new OwnerMovedListener();

    protected boolean isDiagramAssistant(Object object) {
        return object instanceof RoundedRectangleWithTail || object instanceof PopupBarLabelHandle;
    }

    public void mouseHover(MouseEvent me) {
        if (!this.isDiagramAssistant(me.getSource())) {
            this.setAvoidHidingDiagramAssistant(false);
        }
        this.setMouseLocation(me.getLocation());
        if (this.getIsDisplayAtMouseHoverLocation()) {
            this.showDiagramAssistantAfterDelay(this.getAppearanceDelayLocationSpecific());
        } else if (this.shouldShowDiagramAssistant()) {
            this.showDiagramAssistant(this.getMouseLocation());
        }
    }

    public void mouseMoved(MouseEvent me) {
        Object srcObj;
        if (this.getIsDisplayAtMouseHoverLocation() && (srcObj = me.getSource()) != null && srcObj.equals(this.getHostFigure())) {
            this.hideDiagramAssistant();
        }
        this.setAvoidHidingDiagramAssistant(true);
        this.setMouseLocation(me.getLocation());
        if (!this.getIsDisplayAtMouseHoverLocation()) {
            if (!this.isDiagramAssistant(me.getSource())) {
                this.setAvoidHidingDiagramAssistant(false);
            }
            this.showDiagramAssistantAfterDelay(this.getAppearanceDelay());
        }
    }

    private void setFlag(int bit, boolean b) {
        if (b) {
            this.myPopupBarFlags |= bit;
        } else if (this.getFlag(bit)) {
            this.myPopupBarFlags ^= bit;
        }
    }

    private boolean getFlag(int bit) {
        return (this.myPopupBarFlags & bit) > 0;
    }

    private void setPopupBarOnDiagramActivated(boolean bVal) {
        this.setFlag(POPUPBAR_ONDIAGRAMACTIVATED, bVal);
    }

    private boolean getPopupBarOnDiagramActivated() {
        return this.getFlag(POPUPBAR_ONDIAGRAMACTIVATED);
    }

    protected void setHostConnection(boolean bVal) {
        this.setFlag(POPUPBAR_HOST_IS_CONNECTION, bVal);
    }

    protected boolean isHostConnection() {
        return this.getFlag(POPUPBAR_HOST_IS_CONNECTION);
    }

    protected void populatePopupBars() {
        this.fillPopupBarDescriptors();
        PopupBarDescriptor[] descriptors = PopupBarDescriptorRegistory.getDescriptors(this.getHost());
        int i = 0;
        while (i < descriptors.length) {
            this.myPopupBarDescriptors.add(descriptors[i]);
            ++i;
        }
    }

    protected void fillPopupBarDescriptors() {
    }

    private boolean isSelectionToolActive() {
        Tool theTool;
        return this.getHost().getParent() != null && this.getHost().isActive() && (theTool = this.getHost().getViewer().getEditDomain().getActiveTool()) != null && theTool instanceof SelectionTool;
    }

    protected boolean shouldShowDiagramAssistant() {
        if (!super.shouldShowDiagramAssistant()) {
            return false;
        }
        if (this.getIsDisplayAtMouseHoverLocation()) {
            if (this.isHostConnection()) {
                return this.isSelectionToolActive();
            }
            if (this.getPopupBarOnDiagramActivated()) {
                return this.isSelectionToolActive();
            }
            return false;
        }
        return this.isSelectionToolActive();
    }

    protected List getPopupBarDescriptors() {
        return this.myPopupBarDescriptors;
    }

    private void initPopupBars() {
        List theList = this.getPopupBarDescriptors();
        if (theList.isEmpty()) {
            return;
        }
        this.myBalloon = this.createPopupBarFigure();
        int iTotal = ACTION_MARGIN_RIGHT;
        int height = ACTION_WIDTH_HGT;
        for (PopupBarDescriptor desc : theList) {
            Dimension size = desc.getDimension();
            iTotal += size.width;
            if (height >= size.height) continue;
            height = size.height;
        }
        this.getBalloon().setSize(iTotal, height + 2 * ACTION_BUTTON_START_Y);
        int xLoc = ACTION_BUTTON_START_X;
        int yLoc = ACTION_BUTTON_START_Y;
        for (PopupBarDescriptor desc : theList) {
            PopupBarLabelHandle b = new PopupBarLabelHandle(desc.getDragTracker(), desc.getIcon());
            Rectangle r1 = new Rectangle();
            r1.setLocation(xLoc, yLoc);
            Dimension d = desc.getDimension();
            xLoc += d.width;
            r1.setSize(d);
            if (desc.getToolTip() != null) {
                Label l = new Label();
                l.setText(desc.getToolTip());
                b.setToolTip((IFigure)l);
            }
            b.setPreferredSize(d);
            b.setBounds(r1);
            this.getBalloon().add((IFigure)b);
            if (desc.getDragTracker() == null) continue;
            b.addMouseMotionListener(this);
            b.addMouseListener((MouseListener)this.myMouseKeyListener);
        }
    }

    String getPreferenceName() {
        return null;
    }

    protected boolean isDiagramAssistantShowing() {
        return this.getBalloon() != null;
    }

    private IFigure getBalloon() {
        return this.myBalloon;
    }

    protected IFigure createPopupBarFigure() {
        return new RoundedRectangleWithTail();
    }

    protected void showDiagramAssistant(Point referencePoint) {
        if (this.getBalloon() != null && this.getBalloon().getParent() != null) {
            return;
        }
        if (this.myPopupBarDescriptors.isEmpty()) {
            this.populatePopupBars();
            this.initPopupBars();
            if (this.myPopupBarDescriptors.isEmpty()) {
                return;
            }
        }
        this.getBalloon().addMouseMotionListener((MouseMotionListener)this);
        this.getBalloon().addMouseListener((MouseListener)this.myMouseKeyListener);
        IFigure layer = this.getLayer("Handle Layer");
        layer.add(this.getBalloon());
        if (referencePoint == null) {
            referencePoint = this.getHostFigure().getBounds().getCenter();
        }
        Point thePoint = this.getBalloonPosition(referencePoint);
        this.getBalloon().setLocation(thePoint);
        if (!this.shouldAvoidHidingDiagramAssistant()) {
            this.hideDiagramAssistantAfterDelay(this.getDisappearanceDelay());
        }
    }

    protected boolean getIsDisplayAtMouseHoverLocation() {
        return this.getFlag(POPUPBAR_DISPLAYATMOUSEHOVERLOCATION);
    }

    protected void setIsDisplayAtMouseHoverLocation(boolean bVal) {
        this.setFlag(POPUPBAR_DISPLAYATMOUSEHOVERLOCATION, bVal);
    }

    private Point getBalloonPosition(Point referencePoint) {
        Point thePoint = new Point();
        boolean atMouse = this.getIsDisplayAtMouseHoverLocation();
        if (atMouse) {
            thePoint.setLocation(referencePoint);
            this.getHostFigure().translateToAbsolute((Translatable)thePoint);
            this.getBalloon().translateToRelative((Translatable)thePoint);
            thePoint.y -= ACTION_WIDTH_HGT;
            this.adjustToFitInViewport(thePoint);
        } else {
            Dimension theoffset = new Dimension();
            Rectangle rcBounds = this.getHostFigure().getBounds().getCopy();
            this.getHostFigure().translateToAbsolute((Translatable)rcBounds);
            this.getBalloon().translateToRelative((Translatable)rcBounds);
            theoffset.height = -(BALLOON_Y_OFFSET + ACTION_WIDTH_HGT);
            theoffset.width = (int)((double)rcBounds.width * this.myBallonOffsetPercent);
            thePoint.x = rcBounds.x + theoffset.width;
            thePoint.y = rcBounds.y + theoffset.height;
            this.adjustToFitInViewport(thePoint);
        }
        return thePoint;
    }

    private void adjustToFitInViewport(Point balloonLocation) {
        Control control = this.getHost().getViewer().getControl();
        if (control instanceof FigureCanvas) {
            int xDiff;
            Rectangle viewportRect = ((FigureCanvas)control).getViewport().getClientArea();
            Rectangle balloonRect = new Rectangle(balloonLocation, this.getBalloon().getSize());
            int yDiff = viewportRect.y - balloonRect.y;
            if (yDiff > 0) {
                balloonLocation.translate(0, yDiff);
            }
            if ((xDiff = balloonRect.right() - viewportRect.right()) > 0) {
                balloonLocation.translate(-xDiff, 0);
            }
        }
    }

    private void teardownPopupBar() {
        this.getBalloon().removeMouseMotionListener((MouseMotionListener)this);
        this.getBalloon().removeMouseListener((MouseListener)this.myMouseKeyListener);
        IFigure layer = this.getLayer("Handle Layer");
        if (this.myBalloon.getParent() != null) {
            layer.remove(this.myBalloon);
        }
        this.myBalloon = null;
        this.myPopupBarDescriptors.clear();
        if (this.imagesToBeDisposed != null) {
            Iterator iter = this.imagesToBeDisposed.iterator();
            while (iter.hasNext()) {
                ((Image)iter.next()).dispose();
            }
            this.imagesToBeDisposed.clear();
        }
    }

    protected void hideDiagramAssistant() {
        if (this.getBalloon() != null) {
            this.teardownPopupBar();
        }
    }

    protected void showDiagramAssistantAfterDelay(int theDelay) {
        if (!this.isDiagramAssistantShowing()) {
            super.showDiagramAssistantAfterDelay(theDelay);
        }
    }

    public void activate() {
        super.activate();
        this.getHostFigure().addMouseListener((MouseListener)this.myMouseKeyListener);
        this.getHostFigure().addFigureListener((FigureListener)this.myOwnerMovedListener);
    }

    public void deactivate() {
        this.getHostFigure().removeMouseListener((MouseListener)this.myMouseKeyListener);
        this.getHostFigure().removeFigureListener((FigureListener)this.myOwnerMovedListener);
        super.deactivate();
    }

    protected void setRightHandDisplay() {
        this.myBallonOffsetPercent = BALLOON_X_OFFSET_RHS;
    }

    protected void setLeftHandDisplay() {
        this.myBallonOffsetPercent = BALLOON_X_OFFSET_LHS;
    }

    protected boolean isRightDisplay() {
        return BALLOON_X_OFFSET_RHS == this.myBallonOffsetPercent;
    }

    protected int getAppearanceDelayLocationSpecific() {
        return this.getAppearanceDelay();
    }

    protected String getDiagramAssistantID() {
        return PopupBarEditPolicy.class.getName();
    }

    private class OwnerMovedListener
    implements FigureListener {
        private Point myPopupBarLastPosition = new Point(0, 0);

        private OwnerMovedListener() {
        }

        boolean hasPositionChanged(Rectangle theBounds) {
            if (theBounds.x != this.myPopupBarLastPosition.x) {
                return true;
            }
            return theBounds.y != this.myPopupBarLastPosition.y;
        }

        public void figureMoved(IFigure source) {
            if (PopupBarEditPolicy.this.getFlag(POPUPBAR_MOVE_FIGURE) && this.hasPositionChanged(source.getBounds())) {
                PopupBarEditPolicy.this.hideDiagramAssistant();
            } else {
                PopupBarEditPolicy.this.setFlag(POPUPBAR_MOVE_FIGURE, false);
                Rectangle theBounds = source.getBounds();
                this.myPopupBarLastPosition.setLocation(theBounds.x, theBounds.y);
            }
        }
    }

    private class PopupBarLabelHandle
    extends Label
    implements Handle {
        private boolean myMouseOver;
        private Image myDisabledImage;
        private DragTracker myDragTracker;

        private Image getDisabledImage() {
            if (this.myDisabledImage != null) {
                return this.myDisabledImage;
            }
            Image theImage = this.getIcon();
            if (theImage == null) {
                return null;
            }
            this.myDisabledImage = new Image((Device)Display.getCurrent(), theImage, 1);
            if (PopupBarEditPolicy.this.imagesToBeDisposed == null) {
                PopupBarEditPolicy.this.imagesToBeDisposed = new ArrayList();
            }
            PopupBarEditPolicy.this.imagesToBeDisposed.add(this.myDisabledImage);
            return this.myDisabledImage;
        }

        public PopupBarLabelHandle(DragTracker tracker, Image theImage) {
            super(theImage);
            this.myMouseOver = false;
            this.myDisabledImage = null;
            this.myDragTracker = null;
            this.myDragTracker = tracker;
            this.setOpaque(true);
            this.setBackgroundColor(ColorConstants.buttonLightest);
            this.calculateEnabled();
            if (this.myDragTracker != null) {
                this.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

                    public void mouseHover(MouseEvent me) {
                        List children = PopupBarEditPolicy.this.getBalloon().getChildren();
                        int i = 0;
                        while (i < children.size()) {
                            Object child = children.get(i);
                            if (child instanceof PopupBarLabelHandle) {
                                ((PopupBarLabelHandle)((Object)child)).calculateEnabled();
                                ((PopupBarLabelHandle)((Object)child)).repaint();
                            }
                            ++i;
                        }
                    }
                });
            }
        }

        public Point getAccessibleLocation() {
            return null;
        }

        public DragTracker getDragTracker() {
            return this.myDragTracker;
        }

        protected void paintBorder(Graphics graphics) {
            super.paintBorder(graphics);
            if (this.myMouseOver) {
                Rectangle area = this.getClientArea();
                graphics.setForegroundColor(ColorConstants.black);
                graphics.setBackgroundColor(ColorConstants.white);
                graphics.drawFocus(area.x, area.y, area.width - 1, area.height - 1);
            }
        }

        public void handleMouseEntered(MouseEvent event) {
            this.calculateEnabled();
            super.handleMouseEntered(event);
            this.myMouseOver = true;
            this.repaint();
        }

        public void handleMouseExited(MouseEvent event) {
            super.handleMouseExited(event);
            this.myMouseOver = false;
            this.repaint();
        }

        public void handleMousePressed(MouseEvent event) {
            if (1 == event.button) {
                this.setFlag(POPUPBAR_MOVE_FIGURE, true);
            }
            super.handleMousePressed(event);
        }

        private void calculateEnabled() {
            if (this.myDragTracker != null && this.myDragTracker instanceof PopupBarTool) {
                PopupBarTool popupBarTool = (PopupBarTool)this.myDragTracker;
                this.setEnabled(popupBarTool.isCommandEnabled());
            } else {
                this.setEnabled(true);
            }
        }

        protected void paintFigure(Graphics graphics) {
            Image theImage;
            if (!this.isEnabled() && (theImage = this.getDisabledImage()) != null) {
                graphics.translate(this.bounds.x, this.bounds.y);
                graphics.drawImage(theImage, this.getIconLocation());
                graphics.translate(-this.bounds.x, -this.bounds.y);
                return;
            }
            super.paintFigure(graphics);
        }
    }

    private class PopupBarMouseListener
    extends MouseListener.Stub {
        private PopupBarMouseListener() {
        }

        public void mousePressed(MouseEvent me) {
            if (3 == me.button) {
                PopupBarEditPolicy.this.hideDiagramAssistant();
            }
            super.mousePressed(me);
            PopupBarEditPolicy.this.setPopupBarOnDiagramActivated(true);
        }

        public void mouseReleased(MouseEvent me) {
            super.mouseReleased(me);
        }
    }

    private class RoundedRectangleWithTail
    extends RoundedRectangle {
        private Image myTailImage = null;
        private boolean bIsInit = false;
        private int myCornerDimension = 6;

        public RoundedRectangleWithTail() {
            this.setFill(true);
            this.setBackgroundColor(ColorConstants.buttonLightest);
            this.setForegroundColor(ColorConstants.lightGray);
            this.setVisible(true);
            this.setEnabled(true);
            this.setOpaque(true);
        }

        public void paintFigure(Graphics graphics) {
            int shiftWidth = 3;
            Image theTail = this.getTail();
            Rectangle theBounds = this.getBounds().getCopy();
            theBounds.height -= theTail.getBounds().height;
            theBounds.height -= shiftWidth;
            theBounds.x += shiftWidth;
            theBounds.width -= shiftWidth + 1;
            graphics.fillRoundRectangle(theBounds, this.myCornerDimension, this.myCornerDimension);
            graphics.drawRoundRectangle(theBounds, this.myCornerDimension, this.myCornerDimension);
            graphics.drawImage(theTail, theBounds.x + 6, theBounds.y + theBounds.height - 1);
        }

        private Image getTail() {
            if (!this.bIsInit) {
                if (PopupBarEditPolicy.this.getIsDisplayAtMouseHoverLocation() && !PopupBarEditPolicy.this.isHostConnection()) {
                    if (this.myTailImage == null) {
                        this.myTailImage = IMAGE_POPUPBAR_PLUS;
                        this.bIsInit = true;
                    }
                } else if (this.myTailImage == null) {
                    this.myTailImage = IMAGE_POPUPBAR;
                    this.bIsInit = true;
                }
            }
            return this.myTailImage;
        }
    }
}

