/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout.editpolicies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sf.maskat.core.MaskatCorePlugin;
import jp.sf.maskat.core.layout.ComponentRegistry;
import jp.sf.maskat.core.layout.UnknownComponentClass;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.editors.layout.actions.CreateComponentAction;
import jp.sf.maskat.ui.editors.layout.editpolicies.PopupBarDescriptor;
import jp.sf.maskat.ui.editors.layout.requests.BeanCreationFactory;
import jp.sf.maskat.ui.editors.layout.tools.PopupBarTool;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class PopupBarDescriptorRegistory {
    private static Map entries = new HashMap();
    private static final int POPUP_BUTTON_WIDTH = 30;
    private static final int POPUP_SEPARATOR_WIDHT = 16;
    private static final int POPUP_BUTTON_HEIGHT = 20;

    static {
        CreationFactoryRegistory registory = new CreationFactoryRegistory();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("jp.sf.maskat.ui", "popupEntries");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            PopupBarDescriptorRegistory.registorDescriptor(extensions[i].getConfigurationElements(), registory);
            ++i;
        }
    }

    private static void registorDescriptor(IConfigurationElement[] elements, CreationFactoryRegistory registory) {
        int i = 0;
        while (i < elements.length) {
            block9: {
                IConfigurationElement element = elements[i];
                if ("editPart".equals(element.getName())) {
                    Class<?> editPartClass = null;
                    try {
                        editPartClass = element.createExecutableExtension("class").getClass();
                    }
                    catch (CoreException e) {
                        MaskatCorePlugin.log((IStatus)e.getStatus());
                        break block9;
                    }
                    ArrayList<Descriptor> list = (ArrayList<Descriptor>)entries.get(editPartClass);
                    if (list == null) {
                        list = new ArrayList<Descriptor>();
                        entries.put(editPartClass, list);
                    }
                    IConfigurationElement[] children = element.getChildren();
                    int j = 0;
                    while (j < children.length) {
                        IConfigurationElement child = children[j];
                        if ("create".equals(child.getName())) {
                            String namespaceURI = child.getAttribute("namespaceURI");
                            String name = child.getAttribute("name");
                            String message = child.getAttribute("message");
                            ImageDescriptor img = MaskatUIPlugin.getImageDescriptor(child, "icon");
                            Image icon = img != null ? img.createImage() : null;
                            CreationFactory factory = CreationFactoryRegistory.getCreationFactory(namespaceURI, name);
                            list.add(new CreateDescriptor(message, icon, factory));
                        } else if ("separator".equals(child.getName())) {
                            Image img = MaskatUIPlugin.getImage("IMAGE_SEPARATOR");
                            list.add(new SeparatorDescriptor(img));
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public static PopupBarDescriptor[] getDescriptors(EditPart targetEditPart) {
        List list = (List)entries.get(targetEditPart.getClass());
        if (list == null) {
            return new PopupBarDescriptor[0];
        }
        ArrayList<PopupBarDescriptor> descriptors = new ArrayList<PopupBarDescriptor>();
        int i = 0;
        while (i < list.size()) {
            Descriptor desciptor = (Descriptor)list.get(i);
            PopupBarTool tracker = null;
            if (desciptor instanceof CreateDescriptor) {
                CreationFactory factory = ((CreateDescriptor)desciptor).getFacotry();
                tracker = new PopupBarTool(targetEditPart, factory);
            }
            descriptors.add(new PopupBarDescriptor(desciptor.getMessage(), desciptor.getIcon(), desciptor.getDimension(), tracker));
            ++i;
        }
        return descriptors.toArray(new PopupBarDescriptor[descriptors.size()]);
    }

    public static List getMenuActions(EditPart targetEditPart) {
        List list = (List)entries.get(targetEditPart.getClass());
        if (list == null) {
            return new ArrayList();
        }
        ArrayList<CreateComponentAction> descriptors = new ArrayList<CreateComponentAction>();
        int i = 0;
        while (i < list.size()) {
            Descriptor desciptor = (Descriptor)list.get(i);
            if (desciptor instanceof CreateDescriptor) {
                descriptors.add(new CreateComponentAction(desciptor.getMessage(), desciptor.getIcon(), ((CreateDescriptor)desciptor).getFacotry(), targetEditPart));
            } else if (desciptor instanceof SeparatorDescriptor) {
                descriptors.add((CreateComponentAction)new Separator());
            }
            ++i;
        }
        return descriptors;
    }

    public static boolean containsDescriptor(EditPart targetEditPart) {
        List list = (List)entries.get(targetEditPart.getClass());
        return list != null && list.size() > 0;
    }

    private static class CreateDescriptor
    extends Descriptor {
        private CreationFactory factory;

        public CreateDescriptor(String message, Image icon, CreationFactory factory) {
            super(message, icon);
            this.factory = factory;
            this.size = new Dimension(30, 20);
        }

        public CreationFactory getFacotry() {
            return this.factory;
        }
    }

    private static class CreationFactoryRegistory {
        private static Map entries = new HashMap();

        public CreationFactoryRegistory() {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("jp.sf.maskat.ui", "paletteEntries");
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if ("creationTool".equals(elements[j].getName())) {
                        CreationFactoryRegistory.addCreationToolEntry(elements[j]);
                    }
                    ++j;
                }
                ++i;
            }
        }

        private static void addCreationToolEntry(IConfigurationElement element) {
            String namespaceURI = element.getAttribute("namespaceURI");
            String name = element.getAttribute("name");
            CreationFactory factory = null;
            try {
                if (element.getAttribute("factory") != null) {
                    factory = (CreationFactory)element.createExecutableExtension("factory");
                } else {
                    Object type;
                    IConfigurationElement[] children = element.getChildren("property");
                    HashMap<String, String> properties = null;
                    if (children != null) {
                        properties = new HashMap<String, String>();
                        int i = 0;
                        while (i < children.length) {
                            String key = children[i].getAttribute("name");
                            String value = children[i].getAttribute("value");
                            properties.put(key, value);
                            ++i;
                        }
                    }
                    type = (type = ComponentRegistry.getComponentType((String)namespaceURI, (String)name)) == null ? new UnknownComponentClass() : type;
                    factory = new BeanCreationFactory(type, properties);
                }
                HashMap<String, CreationFactory> map = (HashMap<String, CreationFactory>)entries.get(namespaceURI);
                if (map == null) {
                    map = new HashMap<String, CreationFactory>();
                    entries.put(namespaceURI, map);
                }
                map.put(name, factory);
            }
            catch (CoreException e) {
                MaskatUIPlugin.log(e.getStatus());
            }
        }

        public static CreationFactory getCreationFactory(String namespaceURI, String name) {
            Map map = (Map)entries.get(namespaceURI);
            return map != null ? (CreationFactory)map.get(name) : null;
        }
    }

    private static class Descriptor {
        private String message;
        private Image icon;
        protected Dimension size;

        public Descriptor(String message, Image icon) {
            this.message = message;
            this.icon = icon;
        }

        public String getMessage() {
            return this.message;
        }

        public Image getIcon() {
            return this.icon;
        }

        public Dimension getDimension() {
            return this.size;
        }
    }

    private static class SeparatorDescriptor
    extends Descriptor {
        public SeparatorDescriptor(Image icon) {
            super(null, icon);
            this.size = new Dimension(16, 20);
        }
    }
}

