/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout.editpolicies;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public abstract class DiagramAssistantEditPolicy
extends GraphicalEditPolicy
implements MouseMotionListener {
    private static final int APPEARANCE_DELAY = 200;
    private static final int DISAPPEARANCE_DELAY = 2000;
    private static final int DISAPPEARANCE_DELAY_UPON_EXIT = 100;
    private Point mouseLocation;
    private FocusListener focusListener = new FocusListener();
    private boolean avoidHidingDiagramAssistant = true;
    private ShowDiagramAssistantJob showDiagramAssistantJob = new ShowDiagramAssistantJob();
    private HideDiagramAssistantJob hideDiagramAssistantJob = new HideDiagramAssistantJob();

    protected abstract boolean isDiagramAssistant(Object var1);

    protected abstract boolean isDiagramAssistantShowing();

    protected abstract void showDiagramAssistant(Point var1);

    protected abstract void hideDiagramAssistant();

    protected boolean shouldShowDiagramAssistant() {
        return this.getHost().isActive() && this.isDiagramPartActive();
    }

    String getPreferenceName() {
        return null;
    }

    private boolean isDiagramPartActive() {
        IWorkbenchPart activePart;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (activePart = page.getActivePart()) instanceof IEditorPart) {
            Object root = ((IEditorPart)activePart).getAdapter(EditPart.class);
            return root != null && root.equals(this.getHost().getRoot());
        }
        return false;
    }

    protected void showDiagramAssistantAfterDelay(int delay) {
        if (delay >= 0) {
            this.showDiagramAssistantJob.setOriginalMouseLocation(this.getMouseLocation());
            this.showDiagramAssistantJob.cancel();
            this.showDiagramAssistantJob.schedule(delay);
        }
    }

    protected void hideDiagramAssistantAfterDelay(int delay) {
        if (this.isDiagramAssistantShowing() && delay >= 0) {
            this.hideDiagramAssistantJob.cancel();
            this.hideDiagramAssistantJob.schedule(delay);
        }
    }

    public void activate() {
        super.activate();
        ((GraphicalEditPart)this.getHost()).getFigure().addMouseMotionListener((MouseMotionListener)this);
        ((GraphicalEditPart)this.getHost()).addEditPartListener((EditPartListener)this.focusListener);
    }

    public void deactivate() {
        ((GraphicalEditPart)this.getHost()).getFigure().removeMouseMotionListener((MouseMotionListener)this);
        ((GraphicalEditPart)this.getHost()).removeEditPartListener((EditPartListener)this.focusListener);
        this.hideDiagramAssistant();
        super.deactivate();
    }

    public void mouseEntered(MouseEvent me) {
        this.setMouseLocation(me.getLocation());
    }

    public void mouseExited(MouseEvent me) {
        this.setMouseLocation(null);
        this.hideDiagramAssistantAfterDelay(this.getDisappearanceDelayUponExit());
    }

    public void mouseMoved(MouseEvent me) {
        this.setMouseLocation(me.getLocation());
        this.setAvoidHidingDiagramAssistant(this.isDiagramAssistant(me.getSource()));
        this.showDiagramAssistantAfterDelay(this.getAppearanceDelay());
    }

    public void mouseHover(MouseEvent me) {
    }

    public void mouseDragged(MouseEvent me) {
    }

    protected int getAppearanceDelay() {
        return 200;
    }

    protected int getDisappearanceDelay() {
        return 2000;
    }

    protected int getDisappearanceDelayUponExit() {
        return 100;
    }

    protected Point getMouseLocation() {
        return this.mouseLocation;
    }

    protected void setMouseLocation(Point mouseLocation) {
        this.mouseLocation = mouseLocation;
    }

    protected void setAvoidHidingDiagramAssistant(boolean avoidHidingDiagramAssistant) {
        this.avoidHidingDiagramAssistant = avoidHidingDiagramAssistant;
    }

    protected boolean shouldAvoidHidingDiagramAssistant() {
        return this.avoidHidingDiagramAssistant;
    }

    protected String getDiagramAssistantID() {
        return null;
    }

    private class FocusListener
    extends EditPartListener.Stub {
        private FocusListener() {
        }

        public void selectedStateChanged(EditPart part) {
            if (part.hasFocus() && DiagramAssistantEditPolicy.this.shouldShowDiagramAssistant()) {
                DiagramAssistantEditPolicy.this.showDiagramAssistant(DiagramAssistantEditPolicy.this.getMouseLocation());
            } else {
                DiagramAssistantEditPolicy.this.hideDiagramAssistant();
            }
        }
    }

    private class HideDiagramAssistantJob
    extends UIJob {
        protected HideDiagramAssistantJob() {
            super("Hide Diagram Assistant");
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (DiagramAssistantEditPolicy.this.getMouseLocation() == null || !DiagramAssistantEditPolicy.this.shouldAvoidHidingDiagramAssistant()) {
                DiagramAssistantEditPolicy.this.hideDiagramAssistant();
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family == DiagramAssistantEditPolicy.this.getDiagramAssistantID();
        }
    }

    private class ShowDiagramAssistantJob
    extends UIJob {
        private Point originalMouseLocation;

        protected ShowDiagramAssistantJob() {
            super("Show Diagram Assistant");
            this.setSystem(true);
        }

        public void setOriginalMouseLocation(Point originalMouseLocation) {
            this.originalMouseLocation = originalMouseLocation;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (this.originalMouseLocation != null && this.originalMouseLocation.equals((Object)DiagramAssistantEditPolicy.this.getMouseLocation())) {
                if (DiagramAssistantEditPolicy.this.isDiagramAssistantShowing() && !DiagramAssistantEditPolicy.this.shouldAvoidHidingDiagramAssistant()) {
                    DiagramAssistantEditPolicy.this.hideDiagramAssistant();
                }
                if (DiagramAssistantEditPolicy.this.shouldShowDiagramAssistant()) {
                    DiagramAssistantEditPolicy.this.hideDiagramAssistantJob.cancel();
                    if (DiagramAssistantEditPolicy.this.getDiagramAssistantID() != null) {
                        Job.getJobManager().wakeUp((Object)DiagramAssistantEditPolicy.this.getDiagramAssistantID());
                    }
                    DiagramAssistantEditPolicy.this.showDiagramAssistant(this.originalMouseLocation);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

