/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout.actions;

import java.util.ArrayList;
import java.util.List;
import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.core.layout.LayoutElement;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.editors.layout.LayoutGraphicalEditor;
import jp.sf.maskat.ui.editors.layout.commands.AddBasicDefCommand;
import jp.sf.maskat.ui.editors.layout.editparts.LayoutElementEditPart;
import jp.sf.maskat.ui.editors.layout.tools.AdvancedSelectionTool;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.menus.CommandContributionItem;

public class PasteComponentAction
extends SelectionAction {
    private LayoutElement targetDef = null;
    private LayoutGraphicalEditor editor = null;
    private boolean menuPaste = false;

    public PasteComponentAction(LayoutGraphicalEditor editor) {
        super((IWorkbenchPart)editor);
        this.editor = editor;
        this.setId(ActionFactory.PASTE.getId());
        this.setText(GEFMessages.PasteAction_Label);
        this.setToolTipText(GEFMessages.PasteAction_Tooltip);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
    }

    protected boolean calculateEnabled() {
        if (!this.checkClipboard()) {
            return false;
        }
        List objects = this.getSelectedObjects();
        if (objects.isEmpty()) {
            return false;
        }
        if (objects.size() > 1) {
            return false;
        }
        Object selectedObj = objects.get(0);
        if (!(selectedObj instanceof EditPart)) {
            return false;
        }
        Object model = ((EditPart)selectedObj).getModel();
        if (!(model instanceof LayoutElement)) {
            return false;
        }
        this.targetDef = (LayoutElement)model;
        List basicDefList = (List)Clipboard.getDefault().getContents();
        return this.canBePasted(basicDefList);
    }

    private boolean checkClipboard() {
        Object clipboardContent = Clipboard.getDefault().getContents();
        if (!(clipboardContent instanceof List)) {
            return false;
        }
        int i = 0;
        while (i < ((List)clipboardContent).size()) {
            if (!(((List)clipboardContent).get(i) instanceof MaskatElement)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void runWithEvent(Event event) {
        this.menuPaste = event.widget instanceof MenuItem;
        if (this.menuPaste && event.widget.getData() instanceof CommandContributionItem) {
            this.menuPaste = false;
        }
        super.runWithEvent(event);
    }

    public void run() {
        if (!this.checkClipboard()) {
            return;
        }
        GraphicalViewer viewer = (GraphicalViewer)this.editor.getAdapter(GraphicalViewer.class);
        Tool tool = viewer.getEditDomain().getActiveTool();
        if (!(tool instanceof AdvancedSelectionTool)) {
            return;
        }
        AdvancedSelectionTool advancedTool = (AdvancedSelectionTool)tool;
        Point point = advancedTool.getMouseLocation();
        if (point.x < 0 && this.menuPaste) {
            this.menuPaste = false;
        }
        Command command = null;
        List basicDefList = (List)Clipboard.getDefault().getContents();
        ArrayList<LayoutElement> source = new ArrayList<LayoutElement>();
        for (LayoutElement def : basicDefList) {
            try {
                LayoutElement clone = (LayoutElement)def.clone();
                source.add(clone);
            }
            catch (CloneNotSupportedException e) {
                MessageDialog.openError((Shell)this.getWorkbenchPart().getSite().getShell(), (String)Messages.getString("layout.cmd.msg.error.title"), (String)Messages.getString("layout.cmd.paste.msg.error"));
                MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 4, e.getMessage(), (Throwable)e));
                return;
            }
        }
        GraphicalEditPart editPart = (GraphicalEditPart)this.getSelectedObjects().get(0);
        PrecisionRectangle rect = new PrecisionRectangle(editPart.getFigure().getBounds().getCopy());
        editPart.getFigure().translateToAbsolute((Translatable)rect);
        point.x = point.x < rect.x ? 0 : point.x - rect.x;
        point.y = point.y < rect.y ? 0 : point.y - rect.y;
        ArrayList<Component> modifiedTop = new ArrayList<Component>();
        ArrayList<Component> modifiedLeft = new ArrayList<Component>();
        Point offset = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        for (LayoutElement element : source) {
            if (element instanceof Component && this.targetDef instanceof Component) {
                Component compDef = (Component)element;
                if (compDef instanceof DynaComponent) {
                    DynaComponentClass dynaClass = (DynaComponentClass)((DynaComponent)compDef).getDynaClass();
                    if (dynaClass.isTopMovable()) {
                        modifiedTop.add(compDef);
                        offset.y = Math.min(compDef.getTop(), offset.y);
                    }
                    if (dynaClass.isLeftMovable()) {
                        modifiedLeft.add(compDef);
                        offset.x = Math.min(compDef.getLeft(), offset.x);
                    }
                } else {
                    modifiedTop.add(compDef);
                    modifiedLeft.add(compDef);
                    offset.y = Math.min(compDef.getTop(), offset.y);
                    offset.x = Math.min(compDef.getLeft(), offset.x);
                }
            }
            command = command == null ? this.genCommand(this.targetDef, element) : command.chain(this.genCommand(this.targetDef, element));
        }
        offset.x = offset.x == Integer.MAX_VALUE ? 0 : offset.x;
        int n = offset.y = offset.y == Integer.MAX_VALUE ? 0 : offset.y;
        if (!this.menuPaste) {
            point.x = 10;
            point.y = 10;
            offset.x = 0;
            offset.y = 0;
        }
        for (Component component : modifiedTop) {
            component.setTop(point.y + component.getTop() - offset.y);
        }
        for (Component component : modifiedLeft) {
            component.setLeft(point.x + component.getLeft() - offset.x);
        }
        this.execute(command);
        ArrayList<Object> toCopy = new ArrayList<Object>();
        for (LayoutElement element : source) {
            try {
                toCopy.add(element.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        }
        if (this.canBePasted(toCopy)) {
            Clipboard.getDefault().setContents(toCopy);
        } else {
            this.refresh();
        }
    }

    private Command genCommand(LayoutElement parentDef, LayoutElement childDef) {
        return new AddBasicDefCommand((MaskatElement)this.targetDef, (MaskatElement)childDef);
    }

    private boolean canBePasted(List basicDefList) {
        GraphicalViewer viewer = (GraphicalViewer)this.editor.getAdapter(GraphicalViewer.class);
        ArrayList<GraphicalEditPart> sourceEPList = new ArrayList<GraphicalEditPart>();
        for (LayoutElement def : basicDefList) {
            GraphicalEditPart ep = (GraphicalEditPart)viewer.getEditPartFactory().createEditPart(null, (Object)def);
            ep.setModel((Object)def);
            FigureCanvas canvas = (FigureCanvas)viewer.getControl();
            Rectangle rec = canvas.getViewport().getBounds();
            ep.getFigure().setBounds(new Rectangle(rec.width, rec.height, 0, 0));
            sourceEPList.add(ep);
        }
        List objects = this.getSelectedObjects();
        EditPart targetEP = (EditPart)objects.get(0);
        if (targetEP instanceof LayoutElementEditPart) {
            int i = 0;
            while (i < sourceEPList.size()) {
                if (!((LayoutElementEditPart)targetEP).canAddChild(((EditPart)sourceEPList.get(i)).getModel())) {
                    return false;
                }
                EditPart sourceEditPart = (EditPart)sourceEPList.get(i);
                if (sourceEditPart instanceof LayoutElementEditPart && !((LayoutElementEditPart)sourceEditPart).canAddParent(targetEP.getModel())) {
                    return false;
                }
                ++i;
            }
        }
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"add children");
        request.setEditParts(sourceEPList);
        Command command = targetEP.getCommand((Request)request);
        return command == null ? false : command.canExecute();
    }
}

