/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout.actions;

import jp.sf.maskat.ui.editors.layout.editparts.LayoutElementEditPart;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class CreateComponentAction
extends Action {
    private CreationFactory factory = null;
    private EditPart targetEditPart = null;

    public CreateComponentAction(String message, Image image, CreationFactory factory, EditPart target) {
        super(message, ImageDescriptor.createFromImage((Image)image));
        this.factory = factory;
        this.targetEditPart = target;
    }

    private Request createTargetRequest() {
        CreateRequest request = new CreateRequest();
        request.setFactory(this.factory);
        request.setLocation(this.getMouseLocation());
        request.setSize(new Dimension(-1, -1));
        return request;
    }

    private Point getMouseLocation() {
        IFigure figure = ((GraphicalEditPart)this.targetEditPart).getFigure();
        Rectangle rect = figure.getBounds().getCopy();
        Insets inset = figure.getInsets();
        if (inset != null) {
            rect.x += inset.left;
            rect.y += inset.top;
        }
        return new Point(rect.x, rect.y);
    }

    public boolean isEnabled() {
        EditPartViewer viewer = this.targetEditPart.getViewer();
        Object model = this.factory.getNewObject();
        EditPart child = viewer.getEditPartFactory().createEditPart(null, model);
        if (this.targetEditPart instanceof LayoutElementEditPart && !((LayoutElementEditPart)this.targetEditPart).canAddChild(model)) {
            return false;
        }
        return !(child instanceof LayoutElementEditPart) || ((LayoutElementEditPart)child).canAddParent(this.targetEditPart.getModel());
    }

    public void run() {
        Request request = this.createTargetRequest();
        Command command = this.targetEditPart.getCommand(request);
        if (command.canExecute()) {
            Object editPart;
            CommandStack cs = (CommandStack)this.targetEditPart.getAdapter(CommandStack.class);
            cs.execute(command);
            Object model = ((CreateRequest)request).getNewObject();
            EditPartViewer viewer = this.targetEditPart.getViewer();
            if (model != null && viewer != null && (editPart = viewer.getEditPartRegistry().get(model)) instanceof EditPart) {
                viewer.select((EditPart)editPart);
            }
        }
    }
}

