/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui;

import java.net.URI;
import jp.sf.maskat.ui.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.filesystem.FileSystemSupportRegistry;

public class MaskatFrameworkDialogArea
extends Composite {
    private Text maskatFWPath;
    private boolean valid;
    private String errorMessage;
    private IProject selectProject;

    public MaskatFrameworkDialogArea(IProject project, Composite parent, int style) {
        super(parent, style);
        this.selectProject = project;
        this.createControl();
    }

    private void createControl() {
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(768));
        Group fwGroup = new Group((Composite)this, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginLeft = 5;
        fwGroup.setLayout((Layout)layout);
        fwGroup.setLayoutData((Object)new GridData(1808));
        fwGroup.setText(Messages.getString("property.title"));
        Label dirLabel = new Label((Composite)fwGroup, 0);
        dirLabel.setText(Messages.getString("property.label.framework"));
        this.maskatFWPath = new Text((Composite)fwGroup, 2048);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.maskatFWPath.setLayoutData((Object)gridData);
        this.maskatFWPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MaskatFrameworkDialogArea.this.setValid(MaskatFrameworkDialogArea.this.validatePage());
            }
        });
        Button button = new Button((Composite)fwGroup, 8);
        button.setText(Messages.getString("property.browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MaskatFrameworkDialogArea.this.handleBrowse();
            }
        });
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, Messages.getString("property.selectdialog.title"));
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.maskatFWPath.setText(((Path)result[0]).toString());
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String newMessage) {
        this.errorMessage = newMessage;
    }

    private boolean validatePage() {
        URI fwUrl;
        String path = this.maskatFWPath.getText();
        if (path == null || path.length() == 0) {
            this.setErrorMessage(Messages.getString("property.msg.error.notpath"));
            this.maskatFWPath.setFocus();
            return false;
        }
        IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
        IStatus fwLocationStatus = workspace.validateProjectLocationURI(this.selectProject, fwUrl = FileSystemSupportRegistry.getInstance().getDefaultConfiguration().getContributor().getURI(path));
        if (!fwLocationStatus.isOK()) {
            this.setErrorMessage(fwLocationStatus.getMessage());
            this.maskatFWPath.setFocus();
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void setMaskatFWPath(String path) {
        this.maskatFWPath.setText(path);
    }

    public void setMaskatFWPath(IPath path) {
        this.maskatFWPath.setText(path.toString());
    }

    public String getMaskatFWPath() {
        return this.maskatFWPath.getText();
    }
}

