/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.core.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.ComponentLibrary;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaContainer;
import jp.sf.maskat.core.layout.DynaProperty;
import org.apache.commons.beanutils.BasicDynaClass;

public class DynaComponentClass
extends BasicDynaClass {
    private static final long serialVersionUID = 5110101941810053916L;
    public static final int NONE = 0;
    public static final int RESIZABLE_WIDTH = 1;
    public static final int RESIZABLE_HEIGHT = 2;
    public static final int RESIZABLE_BOTH = 3;
    public static final int NO_FOCUS = 4;
    public static final int CONTAINER = 8;
    public static final int COMPONENT = 16;
    public static final int ITEM = 32;
    public static final int MOVABLE_TOP = 64;
    public static final int MOVABLE_LEFT = 128;
    public static final int MOVABLE_BOTH = 192;
    public static final int WIDGET_NAME = 256;
    private ComponentLibrary library;
    private String[] eventTypes;
    private int flag = 0;
    private Map dafaultValues = null;
    private Map childWidgets = null;
    private String qualifiedName;

    public DynaComponentClass() {
    }

    public DynaComponentClass(String name, Class dynaBeanClass, DynaProperty[] properties) {
        super(name, dynaBeanClass, (org.apache.commons.beanutils.DynaProperty[])properties);
        this.dafaultValues = new HashMap();
        this.childWidgets = new HashMap();
    }

    public DynaComponentClass(ComponentLibrary library, String name, DynaProperty[] properties, String[] eventTypes, Map values, Map childWidgets, int flag) {
        super(name, null, null);
        this.library = library;
        this.flag = flag;
        if (library.getPrefix() != null) {
            StringBuffer sb = new StringBuffer(library.getPrefix());
            sb.append(":");
            sb.append(name);
            this.qualifiedName = sb.toString();
        }
        this.dafaultValues = values == null ? new HashMap() : values;
        this.childWidgets = childWidgets == null ? new HashMap() : childWidgets;
        this.setDynaBeanClass(this.isContainer() ? DynaContainer.class : DynaComponent.class);
        this.setProperties(properties);
        this.setEventTypes(eventTypes);
    }

    protected void setProperties(DynaProperty[] properties) {
        ArrayList<DynaProperty> list = new ArrayList<DynaProperty>();
        list.add(new DynaProperty("parent", MaskatElement.class));
        list.add(new DynaProperty("children", List.class));
        if (this.isWidgetName()) {
            list.add(new DynaProperty("name", String.class));
        }
        if (this.isTopMovable()) {
            list.add(new DynaProperty("top", Integer.class));
        }
        if (this.isLeftMovable()) {
            list.add(new DynaProperty("left", Integer.class));
        }
        if (this.isWidthResizable()) {
            list.add(new DynaProperty("width", Integer.class));
        }
        if (this.isHeightResizable()) {
            list.add(new DynaProperty("height", Integer.class));
        }
        if (this.canFocus()) {
            list.add(new DynaProperty("tabIndex", Integer.class));
        }
        if (properties != null) {
            int i = 0;
            while (i < properties.length) {
                list.add(properties[i]);
                ++i;
            }
        }
        super.setProperties((org.apache.commons.beanutils.DynaProperty[])list.toArray(new DynaProperty[list.size()]));
    }

    public void setDynaProperties(DynaProperty[] properties) {
        this.setProperties(properties);
    }

    public String[] getEventTypes() {
        return this.eventTypes;
    }

    public Map getDefaultValues() {
        return this.dafaultValues;
    }

    public boolean isAddChildWidget(String namespaceURI, String name) {
        if (this.childWidgets.size() <= 0) {
            return this.isContainer();
        }
        Map map = (Map)this.childWidgets.get(namespaceURI);
        if (map == null) {
            return false;
        }
        return map.containsKey(name);
    }

    public Map getChildWidgetMap() {
        return this.childWidgets;
    }

    protected void setEventTypes(String[] eventTypes) {
        this.eventTypes = eventTypes;
    }

    public ComponentLibrary getLibrary() {
        return this.library;
    }

    private boolean isFlagSet(int check) {
        return (this.flag & check) > 0;
    }

    public boolean isWidthResizable() {
        return this.isFlagSet(1);
    }

    public boolean isHeightResizable() {
        return this.isFlagSet(2);
    }

    public boolean isTopMovable() {
        return this.isFlagSet(64);
    }

    public boolean isLeftMovable() {
        return this.isFlagSet(128);
    }

    public boolean isContainer() {
        return this.isFlagSet(8);
    }

    public boolean isComponent() {
        return this.isFlagSet(16);
    }

    public boolean isItem() {
        return this.isFlagSet(32);
    }

    public boolean isWidgetName() {
        return this.isFlagSet(256);
    }

    public boolean canFocus() {
        return !this.isFlagSet(4);
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setqualifiedName(String name) {
        this.qualifiedName = name;
    }
}

