/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.core.layout;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import jp.sf.maskat.core.event.Event;
import jp.sf.maskat.core.event.EventDef;
import jp.sf.maskat.core.event.Source;
import jp.sf.maskat.core.event.Target;
import jp.sf.maskat.core.layout.AbstractLayoutElement;
import jp.sf.maskat.core.layout.Component;

public abstract class AbstractComponent
extends AbstractLayoutElement
implements Component {
    private String name;
    private int tabIndex;
    private int left;
    private int top;
    private int width;
    private int height;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.updateComponentIdInEvent(oldName, name);
        this.firePropertyChange("name", oldName, name);
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        int oldHeight = this.height;
        this.height = height;
        if (oldHeight != height) {
            this.firePropertyChange("constraint", "", null);
        }
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        int oldLeft = this.left;
        this.left = left;
        if (oldLeft != left) {
            this.firePropertyChange("constraint", "", null);
        }
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        int oldTop = this.top;
        this.top = top;
        if (oldTop != top) {
            this.firePropertyChange("constraint", "", null);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        int oldWidth = this.width;
        this.width = width;
        if (oldWidth != width) {
            this.firePropertyChange("constraint", "", null);
        }
    }

    public void setConstraint(int left, int top, int width, int height) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
        this.firePropertyChange("constraint", "", null);
    }

    public Component getContainer() {
        if (this.getParent() instanceof Component) {
            return (Component)this.getParent();
        }
        return null;
    }

    public String[] getEventTypes() {
        return new String[0];
    }

    public boolean hasEvent(String eventType) {
        String[] eventTypes = this.getEventTypes();
        if (eventTypes != null && eventTypes.length > 0) {
            int i = 0;
            while (i < eventTypes.length) {
                if (eventTypes[i].equals(eventType)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Event getEvent(String eventType) {
        EventDef eventDef;
        jp.sf.maskat.core.event.Component component;
        if (this.hasEvent(eventType) && (component = (eventDef = this.getLayout().getLayoutDef().getEventDef()).findComponent(this.getName())) != null) {
            return component.findEvent(eventType);
        }
        return null;
    }

    public void setEvent(Event event) {
        if (this.hasEvent(event.getId())) {
            EventDef eventDef = this.getLayout().getLayoutDef().getEventDef();
            jp.sf.maskat.core.event.Component component = eventDef.findComponent(this.getName());
            if (component == null) {
                component = new jp.sf.maskat.core.event.Component();
                component.setId(this.getName());
                eventDef.addChild(component);
            }
            component.setEvent(event);
            this.firePropertyChange("#event", null, event);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    public void firePropertyChange(String propName, Object oldValue, Object newValue) {
        this.listeners.firePropertyChange(propName, oldValue, newValue);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractComponent def = (AbstractComponent)super.clone();
        def.listeners = new PropertyChangeSupport(def);
        return def;
    }

    private void updateComponentIdInEvent(String oldId, String newId) {
        if (oldId == null || oldId.equals(newId)) {
            return;
        }
        if (this.getLayout() == null || this.getLayout().getLayoutDef() == null || this.getLayout().getLayoutDef().getEventDef() == null) {
            return;
        }
        EventDef eventDef = this.getLayout().getLayoutDef().getEventDef();
        jp.sf.maskat.core.event.Component component = eventDef.findComponent(oldId);
        if (component != null) {
            component.setId(newId);
        }
        List sources = this.getAllDescendants(eventDef, Source.class);
        int i = 0;
        while (i < sources.size()) {
            Source source = (Source)sources.get(i);
            if (oldId.equals(source.getObj())) {
                source.setObj(newId);
            }
            if (oldId.equals(source.getIdxRef())) {
                source.setIdxRef(newId);
            }
            ++i;
        }
        List targets = this.getAllDescendants(eventDef, Target.class);
        int i2 = 0;
        while (i2 < targets.size()) {
            Target target = (Target)targets.get(i2);
            if (oldId.equals(target.getIn())) {
                target.setIn(newId);
            }
            if (oldId.equals(target.getOut())) {
                target.setOut(newId);
            }
            ++i2;
        }
    }
}

