/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.core.betwixt;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import jp.sf.maskat.core.layout.ComponentLibrary;
import jp.sf.maskat.core.layout.ComponentRegistry;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.core.layout.DynaContainer;
import jp.sf.maskat.core.layout.UnknownComponent;
import jp.sf.maskat.core.layout.UnknownComponentClass;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.betwixt.io.read.BeanCreationChain;
import org.apache.commons.betwixt.io.read.BeanCreationList;
import org.apache.commons.betwixt.io.read.ElementMapping;
import org.apache.commons.betwixt.io.read.ReadContext;
import org.apache.commons.betwixt.strategy.NamespacePrefixMapper;

public class DynaBeanCreationChain
extends BeanCreationChain {
    public Object create(ElementMapping elementMapping, ReadContext context) {
        Object bean = BeanCreationList.createDefaultChain().create(elementMapping, context);
        if (bean == null || bean instanceof DynaComponent) {
            try {
                Object dynaClass = ComponentRegistry.getComponentType(elementMapping.getNamespace(), elementMapping.getName());
                if (dynaClass == null) {
                    String nameSpace = elementMapping.getNamespace();
                    String prefix = null;
                    if (nameSpace != null && nameSpace.trim().length() > 0) {
                        ComponentLibrary lib = ComponentRegistry.getLibrary(nameSpace);
                        if (lib != null) {
                            prefix = lib.getPrefix();
                        } else if (context != null) {
                            NamespacePrefixMapper mapper = context.getXMLIntrospector().getConfiguration().getPrefixMapper();
                            prefix = mapper.getPrefix(nameSpace);
                        }
                    }
                    bean = new UnknownComponent();
                    dynaClass = new UnknownComponentClass(elementMapping.getName(), UnknownComponent.class, prefix, this.collectProperties(elementMapping));
                    ((UnknownComponent)bean).setDynaClass((DynaClass)((UnknownComponentClass)((Object)dynaClass)));
                } else {
                    if (((DynaComponentClass)((Object)dynaClass)).isContainer()) {
                        bean = new DynaContainer();
                    }
                    bean = bean == null ? new DynaComponent() : bean;
                    ((DynaComponent)bean).setDynaClass((DynaClass)((DynaComponentClass)((Object)dynaClass)));
                }
                context.pushBean(bean);
                context.populateAttributes(context.getXMLIntrospector().introspect(bean).getElementDescriptor().getAttributeDescriptors(), elementMapping.getAttributes());
                context.popBean();
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
        }
        return bean;
    }

    private String[] collectProperties(ElementMapping elementMapping) {
        if (elementMapping == null || elementMapping.getAttributes() == null || elementMapping.getAttributes().getLength() == 0) {
            return new String[]{"context"};
        }
        ArrayList<String> list = new ArrayList<String>();
        int size = elementMapping.getAttributes().getLength();
        int i = 0;
        while (i < size) {
            list.add(elementMapping.getAttributes().getQName(i));
            ++i;
        }
        list.add("context");
        return list.toArray(new String[0]);
    }
}

