/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpart;

import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.LabelDirectEditable;
import jp.sf.maskat.ui.editors.layout.editpolicies.DataBindingEditPolicy;
import jp.sf.maskat.ui.editors.layout.editpolicies.LabelDirectEditPolicy;
import jp.sf.maskat.widget.rialto.editpolicy.TreeNodeComponentEditPolicy;
import jp.sf.maskat.widget.rialto.editpolicy.TreeNodeXYLayoutEditPolicy;
import jp.sf.maskat.widget.rialto.figure.TreeViewFigure;

import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.swt.graphics.Font;


public class TreeNodeEditPart extends ComponentEditPart
	implements LabelDirectEditable {

	public static Font DEFAULT_FONT = new Font(null, "Arial", 8, 0);

	private int layer;
	
	private int leftIterationIndex;

	
	protected IFigure createFigure() {
		Label label = new TreeViewFigure(getLabel());
		label.setBorder(new CompoundBorder(new LineBorder(), new MarginBorder(2)));
		label.setOpaque(false);
		label.setFont(DEFAULT_FONT);
		XYLayout layout = new XYLayout();
		label.setLayoutManager(layout);
		return label;
	}

	protected List getModelChildren() {
		return Collections.EMPTY_LIST;
	}

	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new TreeNodeXYLayoutEditPolicy());
		installEditPolicy(EditPolicy.COMPONENT_ROLE, new TreeNodeComponentEditPolicy());
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE, new LabelDirectEditPolicy());
		installEditPolicy("Snap Feedback", new SnapFeedbackPolicy());
		installEditPolicy(DataBindingEditPolicy.ROLE, new DataBindingEditPolicy());
	}

	protected void refreshVisuals() {
		Dimension dim = figure.getPreferredSize();
		Rectangle constraint = new Rectangle(12 * getLayer(), 
				20 * getLeftIterationIndex(), dim.width, 20);
		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("sText".equals(evt.getPropertyName())) {
			((Label) getFigure()).setText((String) evt.getNewValue());
			getFigure().repaint();
			super.propertyChange(evt);
		}
		if ("addChild".equals(evt.getPropertyName())
				|| "removeChild".equals(evt.getPropertyName())) {
			refreshChildren();
		
			TreeViewEditPart editPart = getTreeViewEditPart(this);
			editPart.refreshChildren();
			forceRefresh();
		}
	}

	private TreeViewEditPart getTreeViewEditPart(EditPart editPart) {
		EditPart parent = editPart.getParent();
		while (!(parent instanceof TreeViewEditPart ||
				parent instanceof RootEditPart)) {
			parent = parent.getParent();
		}
		if (!(parent instanceof TreeViewEditPart)) {
			return null;
		}
		return (TreeViewEditPart) parent;
	}
	
	public void forceRefresh() {
		refresh();
		// すべての子ノードをリフレッシュ
		for (Iterator it = this.getChildren().iterator(); it.hasNext();) {
			((EditPart) it.next()).refresh();
		}
	}

	public int travel(int nextIndex) {
		this.leftIterationIndex = nextIndex++;
		List children = ((DynaComponent) getModel()).getTypedChildren(Component.class);
		TreeViewEditPart treeView = getTreeViewEditPart(this);
		for (int i = 0; i < children.size(); i++) {
			TreeNodeEditPart child = treeView.getModelToEditPart(children.get(i));
			child.setLayer(layer + 1);
			nextIndex = child.travel(nextIndex);
		}
		return nextIndex;
	}

	public boolean canAddChild(Object widget) {
		if (widget instanceof DynaComponent) {
			DynaComponentClass child = (DynaComponentClass)
				((DynaComponent) widget).getDynaClass();

			DynaComponentClass dynaClass = (DynaComponentClass)
				((DynaComponent) getModel()).getDynaClass();
			
			if (dynaClass.getLibrary() == child.getLibrary() &&
				"treeNode".equals(child.getName())) {
				return true;
			}
		}
		return false;
	}
	
	public String getLabel() {
		return (String) ((DynaComponent) getModel()).get("sText");
	}

	public void setLabel(String text) {
		((DynaComponent) getModel()).set("sText", text);
	}

	public int getLayer() {
		return layer;
	}

	public void setLayer(int layer) {
		this.layer = layer;
	}

	public int getLeftIterationIndex() {
		return leftIterationIndex;
	}

	public void setLeftIterationIndex(int leftIterationIndex) {
		this.leftIterationIndex = leftIterationIndex;
	}
	
}
