/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper;

import jp.sf.maskat.core.MaskatElement;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;

public interface ITreeNode {

	/**@return the model associated with this treenode's */
	public MaskatElement getModel();
	
	/**set the model data of this node*/
	public void setModel(MaskatElement model);
	
	/**@return this treenode's image name*/
	public String getImage();
	
	/**@return this treenode's display text*/
	public String getDisplayText();

	/**set the treenode's parent node*/
	public void setParent(ITreeNode parent);
	
	/**@return this treenode's parent node*/
	public ITreeNode getParent();
	
	/**@return this treenode's children nodes*/
	public Object[] getChildren();
	
	/**@return true if it has child node, else false*/
	public boolean hasChildren();
	
	/**whether or not the node contains a childnode who's class type is childClass*/
	public boolean containsChild(Class childClass);
	
	/**add a child node to this treenode*/
	public void addChild(ITreeNode child);
	
	/**remove the specified child node*/
	public void removeChild(ITreeNode child);
	
	/**clear all chilren*/
	public void clearChildren();

	/**@return the context menu to be displayed when right click it*/
	public IMenuManager fillContextMenu(final TreeViewer treeViewer, IMenuManager manager);
	
	/**whether or not the node can be deleted*/
	public boolean isDeletable();
	
	/**whether or not the node can be copyed*/
	public boolean isCopiable();
	
	/**could this node be paste to the parent node or not*/
	public boolean canPasteTo(ITreeNode parent);
}
