/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.layout;

import java.beans.PropertyChangeListener;

import jp.sf.maskat.core.event.Event;


/**
 * Represents a component definition in the layout. 
 * Serves as the "model" object in GEF world.
 * <code>IComponentDef</code>s form a tree. 
 * Every component should have a name that identifies itself.
 */
public interface Component extends LayoutElement {

	/**
	 * Get the <code>IContainerDef</code> which is the container of this
	 * componentDef.
	 * 
	 * @return
	 */
	public Component getContainer();

	public String getName();

	public void setName(String name);

	public int getTabIndex();

	public void setTabIndex(int tabIndex);

	public int getHeight();

	public void setHeight(int height);

	public int getLeft();

	public void setLeft(int left);

	public int getTop();

	public void setTop(int top);

	public int getWidth();

	public void setWidth(int width);

	public void setConstraint(int left, int top, int width, int height);

	public String[] getEventTypes();
	
	public boolean hasEvent(String eventType);

	public Event getEvent(String eventType);
	
	public void setEvent(Event event);

//	public IPropertyDescriptor[] getPropertyDescriptor();
	
	/**
	 * Add the property change listener.
	 * 
	 * @param l
	 */
	public void addPropertyChangeListener(PropertyChangeListener l);

	/**
	 * Remove the property change listener.
	 * 
	 * @param l
	 */
	public void removePropertyChangeListener(PropertyChangeListener l);
}
