/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.layout;

import java.util.List;

/**
 * Abstract implementation of IContainerDef
 */
public abstract class AbstractContainer extends AbstractComponent
	implements Container {

	public void addChild(Object comp) {
		super.addChild(comp);
		firePropertyChange("addChild", "", null);
	}
	
	public void removeChild(Object obj) {
		super.removeChild(obj);
		firePropertyChange("removeChild", "", null);
	}

	public void addChildToIdx(Object comp, int idx) {
		super.addChildToIdx(comp, idx);
		firePropertyChange("addChild", "", null);
	}

	public List getComponents() {
		return getTypedChildren(AbstractComponent.class);
	}
}
