/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.event;

public class Result extends AbstractEventElement {
	
	public static final boolean SOAP_DEFAULT = false;

	private String rootNode;

	private String onErrorTele;

	private String ns;
	
	private boolean soap = SOAP_DEFAULT;

	private boolean enable;
	
	public Result() {
		this(true);
	}

	public Result(boolean enable) {
		this.enable = enable;
	}

	public String getOnErrorTele() {
		return onErrorTele;
	}

	public void setOnErrorTele(String onErrorTele) {
		this.onErrorTele = onErrorTele;
	}

	public String getRootNode() {
		return rootNode;
	}

	public void setRootNode(String rootNode) {
		this.rootNode = rootNode;
	}

	public boolean isSoap() {
		return soap;
	}

	public void setSoap(boolean soap) {
		this.soap = soap;
	}

	public boolean isEnable() {
		return enable;
	}

	public void setEnable(boolean enable) {
		this.enable = enable;
	}

	public Target[] getTargets() {
		return (Target[]) getTypedChildren(Target.class).toArray(new Target[0]);
	}

	public void clearTargets() {
		Target[] targets = getTargets();
		for (int i = 0; i < targets.length; i++) {
			removeChild(targets[i]);
		}
	}

	public String getNs() {
		return ns;
	}

	public void setNs(String ns) {
		this.ns = ns;
	}

}
