/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.html;

import java.util.LinkedHashMap;
import java.util.Map;

import jp.sf.maskat.runtime.PropertyInitializer;

public class HtmlPropertyInitializer implements PropertyInitializer {

	public void initialize(Map properties, boolean enabled) {
		Map property = (Map) properties.get("html");
		if (property == null) {
			property = new LinkedHashMap();
			properties.put("html", property);
		}
		property.put("enabled", enabled ? Boolean.TRUE : Boolean.FALSE);
	}
}
