/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.event;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * The instance of this class represents the "eventDef" node of the event
 * definition file.
 */
public class EventDef extends AbstractEventElement {

	private String id;

	private RemoteUrl remoteUrl;

	private Map events = new HashMap();

	private Map eventRefs = new HashMap();

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getRemoteUrl() {
		return (remoteUrl == null) ? null : remoteUrl.getUrl();
	}

	public void setRemoteUrl(String remoteUrl) {
		if (this.remoteUrl == null) {
			addChild(new RemoteUrl());
		}
		this.remoteUrl.setUrl(remoteUrl);
	}

	/**
	 * イベント定義XMLに参照される画面オブジェクト名の集合を取得
	 */
	public Set getAllObjNames() {
		Set result = new HashSet();

		for (Iterator it = events.values().iterator(); it != null && it.hasNext();) {
			Event event = (Event) it.next();
			event.getRelatedObjNames(result);
		}
		for (Iterator it = eventRefs.values().iterator(); it != null && it.hasNext();) {
			EventRef event = (EventRef) it.next();
			event.getRelatedObjNames(result);
		}
		List elements = getTypedChildren(Component.class);
		for (int i = 0; i < elements.size(); i++) {
			Event[] events = ((Component) elements.get(i)).getAllEvents();
			for (int j = 0; j < events.length; j++) {
				events[j].getRelatedObjNames(result);
			}
		}
		return result;
	}

	public void addChild(Object child) {
		super.addChild(child);
		if (child instanceof Component) {
			addComponent((Component) child);
		}
		if (child instanceof Header) {
			addHeader((Header) child);
		}
		if (child instanceof Event) {
			addEvent((Event) child);
		}
		if (child instanceof RemoteUrl) {
			remoteUrl = (RemoteUrl) child;
		}
	}

	private void addComponent(Component comp) {
		if (comp == null || comp.getId() == null) {
			throw new IllegalArgumentException();
		}
	}

	private void addHeader(Header header) {
		if (header == null || header.getName() == null) {
//			throw new IllegalArgumentException();
		}
	}

	public Component findComponent(String id) {
		EventElement[] elements = getAllComponents();
		for (int i = 0; i < elements.length; i++) {
			if (id.equals(((Component) elements[i]).getId())) {
				return (Component) elements[i];
			}
		}
		return null;
	}
	
	public Component[] getAllComponents() {
		return (Component[]) getTypedChildren(Component.class).toArray(new Component[0]);
	}

	public boolean hasComponents() {
		return (this.getTypedChildren(Component.class) == null) ? false : true;
	}

	private void addEvent(Event event) {
		if (event instanceof EventRef) {
			EventRef er = (EventRef) event;
			if (eventRefs == null) {
				eventRefs = new HashMap();
			}
			eventRefs.put(er.getRefid(), er);
			return;
		}
		// event定義
		if (this.events == null) {
			events = new HashMap();
		}
		events.put(event.getId(), event);

	}

	public Event findEvent(String id) {
		if (events == null) {
			return null;
		}
		return (Event) events.get(id);
	}

	public void removeEvent(String id) {
		if (events == null) {
			return;
		}
		events.remove(id);
	}

	public Event[] getAllEvents() {
		return (Event[]) events.values().toArray(new Event[0]);
	}

	public Event findEventRef(String id) {
		return (Event) eventRefs.get(id);
	}

	public EventRef[] getAllEventRefs() {
		return (EventRef[]) eventRefs.values().toArray(new EventRef[0]);
	}

	/**
	 * Set the children of eventRef to the event that refers to it. For all
	 * event that have no param, add one param to it with enabled=false. For all
	 * event that have no result, add one result to it with enabled=false.
	 */
	public void prepareEvent() {
		Component[] components = getAllComponents();
		for (int i = 0; i < components.length; i++) {
			Event[] events = components[i].getAllEvents();
			for (int j = 0; j < events.length; j++) {
				if (events[j].getRef() != null) {
					Event evtRef = findEventRef(events[j].getRef());
					if (evtRef != null) {
						events[j].removeAllChildren();
						List childElements = evtRef.getChildren();
						for (int k = 0; k < childElements.size(); k++) {
							events[j].addChild(childElements.get(k));
						}
					}
					
				}
			}
		}
	}
}
