/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.core.layout;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.sf.maskat.core.MaskatCorePlugin;
import jp.sf.maskat.core.layout.ComponentLibrary;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.core.layout.DynaProperty;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ComponentRegistry {
    private static Map registry = new HashMap();
    private static Map propertyTypes;
    private static ArrayList defaultLibrarys;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    static {
        defaultLibrarys = new ArrayList();
        propertyTypes = new HashMap();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        propertyTypes.put("boolean", clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        propertyTypes.put("int", clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        propertyTypes.put("float", clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        propertyTypes.put("double", clazz4);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        propertyTypes.put("string", clazz5);
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("jp.sf.maskat.core", "widgets");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            ComponentRegistry.registerLibraries(extensions[i].getConfigurationElements());
            ++i;
        }
    }

    private static void registerLibraries(IConfigurationElement[] elements) {
        ComponentLibrary library = null;
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if ("library".equals(element.getName())) {
                String prefix = element.getAttribute("prefix");
                String namespaceURI = element.getAttribute("namespaceURI");
                String defaultlib = element.getAttribute("default");
                boolean isDefault = new Boolean(defaultlib);
                try {
                    if (element.getAttribute("class") != null) {
                        library = (ComponentLibrary)element.createExecutableExtension("class");
                    } else {
                        library = new ComponentLibrary(prefix, namespaceURI, isDefault);
                        ComponentRegistry.registerComponentTypes(library, element.getChildren("widget"));
                    }
                    if (isDefault) {
                        defaultLibrarys.add(library);
                    }
                    registry.put(namespaceURI, library);
                }
                catch (CoreException e) {
                    MaskatCorePlugin.log(e.getStatus());
                }
            }
            ++i;
        }
    }

    private static void registerComponentTypes(ComponentLibrary library, IConfigurationElement[] elements) {
        DynaComponentClass type = null;
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            type = new DynaComponentClass(library, element.getAttribute("name"), ComponentRegistry.collectDynaProperties(element.getChildren("property")), ComponentRegistry.collectEventTypes(element.getChildren("event")), ComponentRegistry.collectDefaultValues(element.getChildren("property")), ComponentRegistry.collectChildrenProperties(element.getChildren("child")), ComponentRegistry.collectFlags(element));
            library.registerComponentType(type.getName(), (Object)type);
            ++i;
        }
    }

    private static Map collectChildrenProperties(IConfigurationElement[] elements) {
        HashMap result = new HashMap();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if ("child".equals(element.getName())) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("repeat", element.getAttribute("repeat"));
                String nameSpace = element.getAttribute("namespaceURI");
                HashMap ns = (HashMap)result.get(nameSpace);
                if (ns == null) {
                    ns = new HashMap();
                    result.put(nameSpace, ns);
                }
                ns.put(element.getAttribute("name"), map);
            }
            ++i;
        }
        return result;
    }

    private static int collectFlags(IConfigurationElement element) {
        int flag = 0;
        if ("container".equals(element.getAttribute("type"))) {
            flag |= 8;
        } else if ("component".equals(element.getAttribute("type"))) {
            flag |= 0x10;
        } else if ("item".equals(element.getAttribute("type"))) {
            flag |= 0x20;
        }
        if (Boolean.valueOf(element.getAttribute("widgetName")).booleanValue()) {
            flag |= 0x100;
        }
        if (!Boolean.valueOf(element.getAttribute("tabFocus")).booleanValue()) {
            flag |= 4;
        }
        if ("width".equals(element.getAttribute("size"))) {
            flag |= 1;
        } else if ("height".equals(element.getAttribute("size"))) {
            flag |= 2;
        } else if ("both".equals(element.getAttribute("size"))) {
            flag |= 3;
        }
        if ("top".equals(element.getAttribute("position"))) {
            flag |= 0x40;
        } else if ("left".equals(element.getAttribute("position"))) {
            flag |= 0x80;
        } else if ("both".equals(element.getAttribute("position"))) {
            flag |= 0xC0;
        }
        return flag;
    }

    private static DynaProperty[] collectDynaProperties(IConfigurationElement[] elements) {
        ArrayList<DynaProperty> result = new ArrayList<DynaProperty>();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if ("property".equals(element.getName())) {
                boolean isCdataSection = false;
                String name = element.getAttribute("name");
                if ("#cdata-section".equalsIgnoreCase(name)) {
                    name = "context";
                    isCdataSection = true;
                } else if ("#text".equalsIgnoreCase(name)) {
                    name = "context";
                }
                Class type = (Class)propertyTypes.get(element.getAttribute("type"));
                DynaProperty property = new DynaProperty(name, type);
                property.setCdataSection(isCdataSection);
                String required = element.getAttribute("required");
                property.setRequired(Boolean.valueOf(required));
                IConfigurationElement[] items = element.getChildren("enum");
                String[] selectItems = new String[items.length];
                int j = 0;
                while (j < items.length) {
                    selectItems[j] = items[j].getAttribute("value");
                    ++j;
                }
                property.setItems(selectItems);
                String editable = element.getAttribute("editable");
                if (editable == null || !"false".equalsIgnoreCase(editable)) {
                    property.setEditable(true);
                } else {
                    property.setEditable(false);
                }
                result.add(property);
            }
            ++i;
        }
        return result.toArray(new DynaProperty[result.size()]);
    }

    private static String[] collectEventTypes(IConfigurationElement[] elements) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if ("event".equals(element.getName())) {
                result.add(element.getAttribute("type"));
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private static Map collectDefaultValues(IConfigurationElement[] elements) {
        HashMap<String, String> result = new HashMap<String, String>();
        int i = 0;
        while (i < elements.length) {
            block18: {
                Class type;
                String value;
                String name;
                block19: {
                    IConfigurationElement element = elements[i];
                    if (!"property".equals(element.getName())) break block18;
                    name = element.getAttribute("name");
                    if ("#cdata-section".equalsIgnoreCase(name) || "#text".equalsIgnoreCase(name)) {
                        name = "context";
                    }
                    value = element.getAttribute("default");
                    type = (Class)propertyTypes.get(element.getAttribute("type"));
                    if (value != null) break block19;
                    Class<?> clazz = class$5;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.lang.Number");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.isAssignableFrom(type)) break block18;
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("java.lang.Boolean");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz2.isAssignableFrom(type)) break block18;
                    value = "";
                }
                String initValue = null;
                try {
                    Class[] classArray = new Class[1];
                    Class<?> clazz = class$4;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    Constructor constructor = type.getConstructor(classArray);
                    initValue = constructor.newInstance(value);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    initValue = value;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    initValue = value;
                }
                catch (InstantiationException instantiationException) {
                    initValue = value;
                }
                catch (IllegalAccessException illegalAccessException) {
                    initValue = value;
                }
                catch (InvocationTargetException invocationTargetException) {
                    initValue = value;
                }
                result.put(name, initValue);
            }
            ++i;
        }
        return result;
    }

    public static Object getComponentType(String namespaceURI, String name) {
        if (namespaceURI == null || !registry.containsKey(namespaceURI)) {
            ComponentLibrary[] libraries = ComponentRegistry.getLibraries();
            int i = 0;
            while (i < libraries.length) {
                ComponentLibrary library = libraries[i];
                if (library.containsComponent(name) && library.isDefault()) {
                    return library.getComponentType(name);
                }
                ++i;
            }
            return null;
        }
        return ComponentRegistry.getLibrary(namespaceURI).getComponentType(name);
    }

    public static ComponentLibrary getLibrary(String namespaceURI) {
        if (!registry.containsKey(namespaceURI)) {
            return null;
        }
        return (ComponentLibrary)registry.get(namespaceURI);
    }

    public static ComponentLibrary[] getLibraries() {
        return registry.values().toArray(new ComponentLibrary[registry.size()]);
    }

    public static boolean isCustomizeComponent(String namespaceURI, String name) {
        if (namespaceURI == null || !registry.containsKey(namespaceURI)) {
            ComponentLibrary[] libraries = ComponentRegistry.getLibraries();
            int i = 0;
            while (i < libraries.length) {
                ComponentLibrary library = libraries[i];
                if (library.containsComponent(name)) {
                    return true;
                }
                ++i;
            }
        }
        return ((ComponentLibrary)registry.get(namespaceURI)).containsComponent(name);
    }

    private ComponentRegistry() {
    }

    public static ComponentLibrary[] getDefaultLibrarys() {
        return defaultLibrarys.toArray(new ComponentLibrary[0]);
    }
}

