/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.core.betwixt;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import jp.sf.maskat.core.betwixt.MaskatNamespacePrefixMapper;
import jp.sf.maskat.core.betwixt.MaskatXMLIntrospector;
import jp.sf.maskat.core.layout.ComponentLibrary;
import jp.sf.maskat.core.layout.ComponentRegistry;
import org.apache.commons.betwixt.io.BeanWriter;
import org.apache.commons.betwixt.io.WriteContext;
import org.apache.commons.betwixt.strategy.NamespacePrefixMapper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MaskatBeanWriter
extends BeanWriter {
    public MaskatBeanWriter() {
        this.setXMLIntrospector(new MaskatXMLIntrospector());
    }

    public MaskatBeanWriter(Writer writer) {
        super(writer);
        this.setXMLIntrospector(new MaskatXMLIntrospector());
    }

    protected void startElement(WriteContext context, String uri, String localName, String qualifiedName, Attributes attr) throws IOException, SAXException {
        if ("children".equals(qualifiedName) && attr.getLength() <= 0) {
            return;
        }
        String defaultPrefix = this.getDefaultPrefix(localName);
        if ("layoutDef".equals(qualifiedName)) {
            NamespacePrefixMapper mapper = this.getXMLIntrospector().getConfiguration().getPrefixMapper();
            Map prefixMap = ((MaskatNamespacePrefixMapper)mapper).getPrefixes();
            AttributesImpl attribute = new AttributesImpl();
            Iterator ite = prefixMap.keySet().iterator();
            while (ite.hasNext()) {
                String key = (String)ite.next();
                if (this.isDefaultNamespaceURI((String)prefixMap.get(key))) continue;
                attribute.addAttribute("", "", "xmlns:" + key, "NOTATION", (String)prefixMap.get(key));
            }
            attr = attribute;
        }
        if (qualifiedName.startsWith(String.valueOf(defaultPrefix) + ":")) {
            super.startElement(context, uri, localName, localName, attr);
        } else {
            super.startElement(context, uri, localName, qualifiedName, attr);
        }
    }

    private String getDefaultPrefix(String localName) {
        ComponentLibrary[] defaultLibrarys = ComponentRegistry.getDefaultLibrarys();
        int i = 0;
        while (i < defaultLibrarys.length) {
            if (defaultLibrarys[i].containsComponent(localName)) {
                return defaultLibrarys[i].getPrefix();
            }
            ++i;
        }
        return "";
    }

    private boolean isDefaultNamespaceURI(String namespace) {
        ComponentLibrary[] defaultLibrarys = ComponentRegistry.getDefaultLibrarys();
        int i = 0;
        while (i < defaultLibrarys.length) {
            if (defaultLibrarys[i].getNamespaceURI().equals(namespace)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void endElement(WriteContext context, String uri, String localName, String qualifiedName) throws IOException, SAXException {
        if ("children".equals(qualifiedName)) {
            return;
        }
        String defaultPrefix = this.getDefaultPrefix(localName);
        if (qualifiedName.startsWith(String.valueOf(defaultPrefix) + ":")) {
            super.endElement(context, uri, localName, localName);
        } else {
            super.endElement(context, uri, localName, qualifiedName);
        }
    }

    public boolean getWriteEmptyElements() {
        return true;
    }
}

