/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.MaskatElementVisitor;
import jp.sf.maskat.core.layout.DynaComponent;

public abstract class AbstractMaskatElement
implements MaskatElement {
    private MaskatElement parent;
    private List children = new ArrayList();

    public MaskatElement getParent() {
        return this.parent;
    }

    public void setParent(MaskatElement parent) {
        this.parent = parent;
    }

    public List getChildren() {
        return this.children;
    }

    public void addChild(Object child) {
        if (child == null || this.children.contains(child)) {
            return;
        }
        if (child instanceof MaskatElement) {
            ((MaskatElement)child).setParent(this);
        }
        this.children.add(child);
    }

    public void removeChild(Object obj) {
        this.children.remove(obj);
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractMaskatElement object = (AbstractMaskatElement)super.clone();
        object.children = new ArrayList();
        object.parent = null;
        List elements = this.getChildren();
        int i = 0;
        while (i < elements.size()) {
            Object element = elements.get(i);
            if (element instanceof MaskatElement) {
                object.addChild(((MaskatElement)element).clone());
            } else if (element instanceof DynaComponent) {
                object.addChild(((DynaComponent)element).clone());
            } else {
                object.addChild(element);
            }
            ++i;
        }
        return object;
    }

    public void removeAllChildren() {
        ArrayList elements = new ArrayList(this.getChildren());
        int i = 0;
        while (i < elements.size()) {
            this.removeChild(elements.get(i));
            ++i;
        }
    }

    public void removeAllByType(Class clazz) {
        ArrayList elements = new ArrayList(this.getChildren());
        int i = 0;
        while (i < elements.size()) {
            Object element = elements.get(i);
            if (clazz.isInstance(element)) {
                this.removeChild(element);
            }
            ++i;
        }
    }

    public void accept(MaskatElementVisitor visitor) {
        List elements = this.getChildren();
        int i = 0;
        while (i < elements.size()) {
            Object element = elements.get(i);
            visitor.visit(element);
            if (element instanceof MaskatElement) {
                ((MaskatElement)element).accept(visitor);
            }
            ++i;
        }
    }

    public List getAllDescendants(MaskatElement parent, Class descendant) {
        ArrayList result = new ArrayList();
        List children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            Object child = children.get(i);
            if (descendant.equals(child.getClass())) {
                result.add(child);
            }
            if (child instanceof MaskatElement) {
                result.addAll(this.getAllDescendants((MaskatElement)child, descendant));
            }
            ++i;
        }
        return result;
    }

    public Map getDefaultValues() {
        return new HashMap();
    }

    public Object getChildByTypeIdx(Class clazz, int idx) {
        if (this.children.size() <= idx) {
            return null;
        }
        int i = 0;
        while (i < this.children.size()) {
            if (clazz.isInstance(this.children.get(i))) {
                if (idx == 0) {
                    return this.children.get(i);
                }
                --idx;
            }
            ++i;
        }
        return null;
    }

    public int getChildIdx(Object child) {
        return this.children == null ? -1 : this.children.indexOf(child);
    }

    public void addChildToIdx(Object child, int idx) {
        if (child == this) {
            throw new IllegalArgumentException("Could not add an object as his own child");
        }
        if (this.children.contains(child)) {
            throw new IllegalStateException("object already exists");
        }
        if (child instanceof MaskatElement) {
            ((MaskatElement)child).setParent(this);
        }
        this.children.add(idx, child);
    }

    public List getTypedChildren(Class clazz) {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < this.children.size()) {
            if (this.children.get(i).getClass().equals(clazz)) {
                list.add(this.children.get(i));
            }
            ++i;
        }
        return list;
    }
}

